/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC74")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="S74")
public class AvoidFullSQLRequest
extends IssuableSubscriptionVisitor {
    protected static final String MESSAGERULE = "Don't use the query SELECT * FROM";
    private static final Predicate<String> SELECT_FROM_REGEXP = Pattern.compile("select\\s*\\*\\s*from", 2).asPredicate();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.STRING_LITERAL);
    }

    public void visitNode(Tree tree) {
        String value = ((LiteralTree)tree).value();
        if (SELECT_FROM_REGEXP.test(value)) {
            this.reportIssue(tree, MESSAGERULE);
        }
    }
}

