/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseContainer;
import io.ebean.docker.commands.RedisConfig;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class RedisContainer
extends BaseContainer {
    public static RedisContainer create(String redisVersion, Properties properties) {
        return new RedisContainer(new RedisConfig(redisVersion, properties));
    }

    public RedisContainer(RedisConfig config) {
        super(config);
    }

    @Override
    boolean checkConnectivity() {
        String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (osName.indexOf("win") > -1) {
            return this.doWindowsCheck();
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("nc", "localhost", Integer.toString(this.config.getPort()));
            pb.redirectErrorStream(true);
            Process process = pb.start();
            OutputStreamWriter ow = new OutputStreamWriter(process.getOutputStream());
            ow.write("PING");
            ow.flush();
            ow.close();
            return process.waitFor() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean doWindowsCheck() {
        try {
            Thread.sleep(20L);
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add(this.config.image);
        return this.createProcessBuilder(args);
    }
}

