/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.ModuleMeta;
import io.ebean.querybean.generator.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

class ReadModuleInfo {
    private final ProcessingContext ctx;

    public ReadModuleInfo(ProcessingContext ctx) {
        this.ctx = ctx;
    }

    ModuleMeta read(Element element) {
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            String name = annotationMirror.getAnnotationType().asElement().toString();
            if (!"io.ebean.config.ModuleInfo".equals(name)) continue;
            List<String> entities = this.readEntities("entities", annotationMirror);
            List<String> other = this.readEntities("other", annotationMirror);
            return new ModuleMeta(entities, other);
        }
        return null;
    }

    private List<String> readEntities(String key, AnnotationMirror mirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> entries = elementValues.entrySet();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : entries) {
            if (!key.equals(entry.getKey().getSimpleName().toString())) continue;
            return this.readAttributes(entry.getValue());
        }
        return Collections.emptyList();
    }

    private List<String> readAttributes(AnnotationValue value) {
        Object entitiesValue = value.getValue();
        if (entitiesValue != null) {
            try {
                ArrayList<String> vals = new ArrayList<String>();
                List coll = (List)entitiesValue;
                for (AnnotationValue annotationValue : coll) {
                    vals.add((String)annotationValue.getValue());
                }
                return vals;
            }
            catch (Exception e) {
                this.ctx.logError(null, "Error reading ModuleInfo annotation, err " + e, new Object[0]);
            }
        }
        return Collections.emptyList();
    }
}

