/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config.platform;

import io.avaje.applog.AppLog;
import io.ebean.config.DatabaseConfig;
import io.ebean.test.config.platform.ClickHouseSetup;
import io.ebean.test.config.platform.CockroachSetup;
import io.ebean.test.config.platform.Config;
import io.ebean.test.config.platform.Db2Setup;
import io.ebean.test.config.platform.ElasticSearchSetup;
import io.ebean.test.config.platform.H2Setup;
import io.ebean.test.config.platform.HanaSetup;
import io.ebean.test.config.platform.MariaDBSetup;
import io.ebean.test.config.platform.MySqlSetup;
import io.ebean.test.config.platform.NuoDBSetup;
import io.ebean.test.config.platform.OracleSetup;
import io.ebean.test.config.platform.PlatformSetup;
import io.ebean.test.config.platform.PostgisSetup;
import io.ebean.test.config.platform.PostgresSetup;
import io.ebean.test.config.platform.RedisSetup;
import io.ebean.test.config.platform.SqlServerSetup;
import io.ebean.test.config.platform.SqliteSetup;
import io.ebean.test.config.platform.YugabyteSetup;
import io.ebean.test.containers.ContainerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;

public class PlatformAutoConfig {
    private static final System.Logger log = AppLog.getLogger((String)"io.ebean.test");
    private static final Map<String, PlatformSetup> KNOWN_PLATFORMS = new HashMap<String, PlatformSetup>();
    private final DatabaseConfig config;
    private final Properties properties;
    private String db;
    private String platform;
    private PlatformSetup platformSetup;
    private String databaseName;

    public PlatformAutoConfig(String db, DatabaseConfig config) {
        this.db = db;
        this.config = config;
        this.properties = config.getProperties();
    }

    public void configExtraDataSource() {
        this.determineTestPlatform();
        if (this.isKnownPlatform()) {
            this.databaseName = this.config.getName();
            this.db = this.config.getName();
            Config config = new Config(this.db, this.platform, this.databaseName, this.config);
            this.platformSetup.setupExtraDbDataSource(config);
            log.log(System.Logger.Level.DEBUG, "configured dataSource for extraDb name:{0} url:{1}", this.db, this.config.getDataSourceConfig().getUrl());
        }
    }

    public void run() {
        this.determineTestPlatform();
        if (this.isKnownPlatform()) {
            this.readDbName();
            this.setupForTesting();
        }
    }

    private void setupForTesting() {
        RedisSetup.run(this.properties);
        CompletableFuture.allOf(CompletableFuture.runAsync(this::setupElasticSearch), CompletableFuture.runAsync(this::setupDatabase)).join();
    }

    private void setupElasticSearch() {
        new ElasticSearchSetup(this.properties).run();
    }

    private void setupDatabase() {
        Config config = new Config(this.db, this.platform, this.databaseName, this.config);
        Properties dockerProperties = this.platformSetup.setup(config);
        if (!dockerProperties.isEmpty()) {
            if (this.isDebug()) {
                log.log(System.Logger.Level.INFO, "Docker properties: {0}", dockerProperties);
            } else {
                log.log(System.Logger.Level.DEBUG, "Docker properties: {0}", dockerProperties);
            }
            new ContainerFactory(dockerProperties, config.getDockerPlatform()).startContainers();
        }
    }

    private boolean isDebug() {
        String val = this.properties.getProperty("ebean.test.debug");
        return val != null && val.equalsIgnoreCase("true");
    }

    private void readDbName() {
        this.databaseName = this.properties.getProperty("ebean.test.dbName");
        if (this.databaseName == null) {
            if (this.inMemoryDb()) {
                this.databaseName = "test_db";
            } else {
                throw new IllegalStateException("ebean.test.dbName is not set but required for testing configuration with platform " + this.platform);
            }
        }
    }

    private boolean inMemoryDb() {
        return this.platformSetup.isLocal();
    }

    private boolean isKnownPlatform() {
        if (this.platform == null) {
            return false;
        }
        this.platformSetup = KNOWN_PLATFORMS.get(this.platform);
        if (this.platformSetup == null) {
            log.log(System.Logger.Level.WARNING, "unknown platform {0} - skipping platform setup", this.platform);
        }
        return this.platformSetup != null;
    }

    private void determineTestPlatform() {
        String testPlatform = this.properties.getProperty("ebean.test.platform");
        if (testPlatform != null && !testPlatform.isEmpty()) {
            if (this.db == null) {
                this.platform = testPlatform.trim();
                this.db = "db";
            } else {
                this.platform = this.db;
            }
        }
    }

    static {
        KNOWN_PLATFORMS.put("h2", new H2Setup());
        KNOWN_PLATFORMS.put("sqlite", new SqliteSetup());
        KNOWN_PLATFORMS.put("postgres", new PostgresSetup());
        KNOWN_PLATFORMS.put("postgis", new PostgisSetup());
        KNOWN_PLATFORMS.put("nuodb", new NuoDBSetup());
        KNOWN_PLATFORMS.put("mysql", new MySqlSetup());
        KNOWN_PLATFORMS.put("mariadb", new MariaDBSetup());
        KNOWN_PLATFORMS.put("sqlserver", new SqlServerSetup());
        KNOWN_PLATFORMS.put("oracle", new OracleSetup());
        KNOWN_PLATFORMS.put("clickhouse", new ClickHouseSetup());
        KNOWN_PLATFORMS.put("cockroach", new CockroachSetup());
        KNOWN_PLATFORMS.put("hana", new HanaSetup());
        KNOWN_PLATFORMS.put("db2", new Db2Setup());
        KNOWN_PLATFORMS.put("yugabyte", new YugabyteSetup());
    }
}

