/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config.platform;

import io.ebean.config.DatabaseConfig;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.test.containers.DockerHost;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Config {
    private static final Logger log = LoggerFactory.getLogger((String)"io.ebean.test");
    private static final String[] DOCKER_TEST_PARAMS = new String[]{"fastStartMode", "inMemory", "initSqlFile", "seedSqlFile", "adminUser", "adminPassword", "extraDb", "extraDb.dbName", "extraDb.username", "extraDb.password", "extraDb.extensions", "extraDb.initSqlFile", "extraDb.seedSqlFile"};
    private static final String[] DOCKER_PLATFORM_PARAMS = new String[]{"containerName", "image", "internalPort", "startMode", "shutdownMode", "maxReadyAttempts", "tmpfs", "collation", "characterSet"};
    private static final String DDL_MODE_OPTIONS = "dropCreate, create, none, migration, createOnly or migrationDropCreate";
    private final String db;
    private final String platform;
    private String dockerPlatform;
    private String databaseName;
    private final Properties properties;
    private int port;
    private String url;
    private String driver;
    private String schema;
    private String username;
    private String password;
    private final DatabaseConfig config;
    private boolean containerDropCreate;
    private final Properties dockerProperties = new Properties();

    Config(String db, String platform, String databaseName, DatabaseConfig config) {
        this.db = db;
        this.platform = platform;
        this.dockerPlatform = platform;
        this.databaseName = databaseName;
        this.config = config;
        this.properties = config.getProperties();
    }

    void setSchemaFromDbName(String newDbName) {
        this.schema = this.databaseName;
        this.databaseName = newDbName;
    }

    void setDockerPlatform(String dockerPlatform) {
        this.dockerPlatform = dockerPlatform;
    }

    void setDefaultPort(int defaultPort) {
        String val = this.getKey("port", null);
        this.port = val != null ? Integer.parseInt(val) : defaultPort;
    }

    void ddlMode(String defaultMode) {
        String ddlMode = this.properties.getProperty("ebean.test.ddlMode", defaultMode);
        if (ddlMode == null) {
            throw new IllegalStateException("No ebean.test.ddlMode set?  Expect one of dropCreate, create, none, migration, createOnly or migrationDropCreate");
        }
        switch (ddlMode.toLowerCase()) {
            case "none": {
                this.disableMigrationRun();
                break;
            }
            case "migrationonly": 
            case "migrationsonly": {
                this.setMigrationRun();
                break;
            }
            case "migrationdropcreate": 
            case "migrationsdropcreate": 
            case "migration": 
            case "migrations": {
                this.setMigrationRun();
                this.containerDropCreate = true;
                break;
            }
            case "createonly": {
                this.setCreate();
                break;
            }
            case "create": {
                this.containerDropCreate = true;
                this.setCreate();
                break;
            }
            case "dropcreate": {
                this.setDropCreate();
                break;
            }
            case "runonly": {
                this.setRunOnly();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ebean.test.ddlMode [" + ddlMode + "] expecting one of dropCreate, create, none, migration, createOnly or migrationDropCreate");
            }
        }
    }

    private void setCreate() {
        this.setDropCreate();
        this.config.setDdlCreateOnly(true);
        this.setDdlProperty("createOnly");
    }

    private void setDropCreate() {
        this.disableMigrationRun();
        this.config.setDdlGenerate(true);
        this.config.setDdlRun(true);
        this.setDdlProperty("generate");
        this.setDdlProperty("run");
        this.setDdlInitSeed();
    }

    private void setRunOnly() {
        this.disableMigrationRun();
        this.config.setDdlGenerate(false);
        this.config.setDdlRun(true);
        this.setDdlProperty("run");
        this.setDdlInitSeed();
    }

    private void setDdlInitSeed() {
        String seedSql;
        String initSql = this.getKey("initSql", null);
        if (initSql != null) {
            this.setProperty("ebean." + this.db + ".ddl.initSql", initSql);
        }
        if ((seedSql = this.getKey("seedSql", null)) != null) {
            this.setProperty("ebean." + this.db + ".ddl.seedSql", seedSql);
        }
    }

    private void setMigrationRun() {
        this.config.setRunMigration(true);
        this.setProperty("ebean." + this.db + ".migration.run", "true");
    }

    private void disableMigrationRun() {
        System.setProperty("ebean.migration.run", "false");
    }

    private void setDdlProperty(String key) {
        this.setProperty("ebean." + this.db + ".ddl." + key, "true");
    }

    DataSourceConfig datasourceDefaults() {
        return this.datasourceDefaults(this.platform);
    }

    void extraDatasourceDefaults() {
        this.datasourceDefaults("extraDb");
    }

    private DataSourceConfig datasourceDefaults(String platform) {
        if (this.username == null) {
            throw new IllegalStateException("username not set?");
        }
        if (this.password == null) {
            throw new IllegalStateException("password not set?");
        }
        DataSourceConfig ds = new DataSourceConfig();
        ds.setUsername(this.datasourceProperty(platform, "username", this.username));
        ds.setPassword(this.datasourceProperty(platform, "password", this.password));
        ds.setOwnerUsername(this.datasourceProperty(platform, "ownerUsername", null));
        ds.setOwnerPassword(this.datasourceProperty(platform, "ownerPassword", null));
        ds.setUrl(this.datasourceProperty(platform, "url", this.url));
        String driverClass = this.datasourceProperty(platform, "driver", this.driver);
        ds.setDriver(driverClass);
        this.config.setDataSourceConfig(ds);
        log.info("Using jdbc settings - username:{} url:{} driver:{}", new Object[]{ds.getUsername(), ds.getUrl(), ds.getDriver()});
        if (driverClass != null) {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("JDBC Driver " + driverClass + " does not appear to be in the classpath?");
            }
        }
        return ds;
    }

    String datasourceProperty(String key, String defaultValue) {
        return this.datasourceProperty(this.platform, key, defaultValue);
    }

    private String datasourceProperty(String platform, String key, String defaultValue) {
        String val = this.getTestKey(platform, key, defaultValue);
        if (val != null) {
            this.setProperty("datasource." + this.db + "." + key, val);
        }
        return val;
    }

    private void setProperty(String dsKey, String val) {
        this.properties.setProperty(dsKey, val);
    }

    private void setUrl(String key, String urlPattern) {
        String val = this.getKey(key, urlPattern);
        val = val.replace("${host}", this.host());
        val = val.replace("${port}", String.valueOf(this.port));
        this.url = val = val.replace("${databaseName}", this.databaseName);
    }

    void setUrl(String urlPattern) {
        this.setUrl("url", urlPattern);
    }

    void setExtraUrl(String urlPattern) {
        this.setUrl("extraDb.url", urlPattern);
    }

    String host() {
        return this.getKey("host", this.getKey("dockerHost", DockerHost.host()));
    }

    void urlAppend(String dbSchemaSuffix) {
        this.url = this.url + dbSchemaSuffix;
    }

    void setDriver(String driver) {
        this.driver = this.getKey("driver", driver);
    }

    void setPasswordDefault() {
        this.setPassword("test");
    }

    void setExtraDbPasswordDefault() {
        this.setExtraDbPassword("test");
    }

    private String deriveDbSchema() {
        String dbSchema = this.properties.getProperty("ebean.dbSchema", this.config.getDbSchema());
        dbSchema = this.properties.getProperty("ebean.test.dbSchema", dbSchema);
        return this.getKey("schema", dbSchema);
    }

    void setUsernameDefault() {
        this.schema = this.first(this.deriveDbSchema());
        String defaultValue = this.schema != null ? this.schema : this.getKey("databaseName", this.databaseName);
        this.username = this.getKey("username", defaultValue);
    }

    void setUsernameDefaultSchema() {
        this.username = this.getKey("username", this.schema);
    }

    void setExtraUsernameDefault() {
        this.username = this.getKey("extraDb.username", this.databaseName);
    }

    private String first(String dbSchema) {
        if (dbSchema == null) {
            return null;
        }
        String[] schemas = dbSchema.split(",");
        if (schemas.length > 1) {
            return schemas[0];
        }
        return dbSchema;
    }

    String getUsername() {
        return this.username;
    }

    String getSchema() {
        return this.schema;
    }

    private void setExtraDbPassword(String password) {
        this.password = this.getKey("extraDb.password", password);
    }

    void setPassword(String password) {
        this.password = this.getKey("password", password);
    }

    void setUsername(String username) {
        this.username = this.getKey("username", username);
    }

    void setDatabaseName(String databaseName) {
        this.databaseName = this.getKey("databaseName", databaseName);
    }

    boolean isUseDocker() {
        String val = this.getPlatformKey("useDocker", this.properties.getProperty("ebean.test.useDocker"));
        return val == null || !val.equalsIgnoreCase("false");
    }

    void setDockerVersion(String version) {
        String mode;
        String val = this.getKey("version", version);
        this.dockerProperties.setProperty(this.dockerKey("version"), val);
        if (this.containerDropCreate) {
            this.dockerProperties.setProperty(this.dockerKey("startMode"), "dropCreate");
        }
        if ((mode = this.properties.getProperty("ebean.test.containerMode")) != null) {
            this.dockerProperties.setProperty(this.dockerKey("startMode"), mode);
        }
        this.initDockerProperties();
    }

    void setDockerContainerName(String containerName) {
        this.dockerProperties.setProperty(this.dockerKey("containerName"), this.getKey("containerName", containerName));
    }

    void setDockerImage(String defaultImage) {
        this.dockerProperties.setProperty(this.dockerKey("image"), this.getKey("image", defaultImage));
    }

    void setExtensions(String defaultValue) {
        this.setExtensionsInternal("extensions", defaultValue);
    }

    void setExtraExtensions(String defaultValue) {
        this.setExtensionsInternal("extraDb.extensions", defaultValue);
    }

    void setExtensionsInternal(String key, String defaultValue) {
        String val = this.getKey(key, defaultValue);
        if (val != null) {
            this.dockerProperties.setProperty(this.dockerKey(key), this.trimExtensions(val));
        }
    }

    String trimExtensions(String val) {
        val = val.replaceAll(" ", "");
        val = val.replaceAll(",,", ",");
        return val;
    }

    private String getTestKey(String platform, String key, String defaultValue) {
        return this.properties.getProperty("ebean.test." + platform + "." + key, defaultValue);
    }

    String getPlatformKey(String key, String defaultValue) {
        return this.properties.getProperty("ebean.test." + this.platform + "." + key, defaultValue);
    }

    String getKey(String key, String defaultValue) {
        defaultValue = this.properties.getProperty("ebean.test." + key, defaultValue);
        return this.properties.getProperty("ebean.test." + this.platform + "." + key, defaultValue);
    }

    private void initDockerProperties() {
        this.dockerProperties.setProperty(this.dockerKey("port"), String.valueOf(this.port));
        this.dockerProperties.setProperty(this.dockerKey("dbName"), this.databaseName);
        if (this.schema != null) {
            this.dockerProperties.setProperty(this.dockerKey("schema"), this.schema);
        }
        this.dockerProperties.setProperty(this.dockerKey("username"), this.username);
        this.dockerProperties.setProperty(this.dockerKey("password"), this.password);
        this.dockerProperties.setProperty(this.dockerKey("url"), this.url);
        if (this.driver != null) {
            this.dockerProperties.setProperty(this.dockerKey("driver"), this.driver);
        }
        this.setDockerOptionalParameters();
    }

    private void setDockerOptionalParameters() {
        String val;
        String mode = this.properties.getProperty("ebean.test.shutdownMode");
        if (mode != null) {
            this.dockerProperties.setProperty(this.dockerKey("shutdownMode"), mode);
        }
        for (String key : DOCKER_TEST_PARAMS) {
            val = this.getKey(key, null);
            val = this.properties.getProperty("docker." + this.platform + "." + key, val);
            if (val == null) continue;
            this.dockerProperties.setProperty(this.dockerKey(key), val);
        }
        for (String key : DOCKER_PLATFORM_PARAMS) {
            val = this.getKey(key, null);
            val = this.properties.getProperty("docker." + this.platform + "." + key, val);
            if (val == null) continue;
            this.dockerProperties.setProperty(this.dockerKey(key), val);
        }
    }

    private String dockerKey(String key) {
        return this.dockerPlatform + "." + key;
    }

    Properties getDockerProperties() {
        return this.dockerProperties;
    }

    void setDatabasePlatformName() {
        String databasePlatformName = this.getKey("databasePlatformName", null);
        if (databasePlatformName != null) {
            this.setProperty("ebean." + this.db + ".databasePlatformName", databasePlatformName);
        }
    }

    String getDockerPlatform() {
        return this.dockerPlatform;
    }
}

