/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.SplitColumns;
import io.ebeaninternal.dbmigration.migration.AddColumn;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AddTableComment;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.AlterTable;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.CreateTable;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropTable;
import io.ebeaninternal.dbmigration.migration.ForeignKey;
import io.ebeaninternal.dbmigration.migration.RenameColumn;
import io.ebeaninternal.dbmigration.migration.RenameTable;
import io.ebeaninternal.dbmigration.migration.UniqueConstraint;
import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MCompoundForeignKey;
import io.ebeaninternal.dbmigration.model.MCompoundUniqueConstraint;
import io.ebeaninternal.dbmigration.model.MIndex;
import io.ebeaninternal.dbmigration.model.MTableIdentity;
import io.ebeaninternal.dbmigration.model.ModelContainer;
import io.ebeaninternal.dbmigration.model.ModelDiff;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.IdentityMode;
import io.ebeaninternal.server.deploy.PartitionMeta;
import io.ebeaninternal.server.deploy.TablespaceMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTable {
    private static final Logger logger = LoggerFactory.getLogger(MTable.class);
    private String name;
    private MTable draftTable;
    private boolean draft;
    private PartitionMeta partitionMeta;
    private TablespaceMeta tablespaceMeta;
    private String pkName;
    private String comment;
    private String storageEngine;
    private IdentityMode identityMode;
    private boolean withHistory;
    private final Map<String, MColumn> columns = new LinkedHashMap<String, MColumn>();
    private final List<MCompoundUniqueConstraint> uniqueConstraints = new ArrayList<MCompoundUniqueConstraint>();
    private final List<MCompoundForeignKey> compoundKeys = new ArrayList<MCompoundForeignKey>();
    private String whenCreatedColumn;
    private AddColumn addColumn;
    private final List<String> droppedColumns = new ArrayList<String>();

    public MTable(BeanDescriptor<?> descriptor) {
        this.name = descriptor.baseTable();
        this.identityMode = descriptor.identityMode();
        this.storageEngine = descriptor.storageEngine();
        this.partitionMeta = descriptor.partitionMeta();
        this.tablespaceMeta = descriptor.tablespaceMeta();
        this.comment = descriptor.dbComment();
        if (descriptor.isHistorySupport()) {
            this.withHistory = true;
            BeanProperty whenCreated = descriptor.whenCreatedProperty();
            if (whenCreated != null) {
                this.whenCreatedColumn = whenCreated.dbColumn();
            }
        }
    }

    MTable(String name) {
        this(name, null, null);
    }

    public MTable(String name, BeanDescriptor<?> descriptor) {
        this(name, descriptor.tablespaceMeta(), descriptor.storageEngine());
    }

    private MTable(String name, TablespaceMeta tablespaceMeta, String storageEngine) {
        this.name = name;
        this.identityMode = IdentityMode.NONE;
        this.tablespaceMeta = tablespaceMeta;
        this.storageEngine = storageEngine;
    }

    public MTable createDraftTable() {
        this.draftTable = new MTable(this.name + "_draft", this.tablespaceMeta, this.storageEngine);
        this.draftTable.draft = true;
        this.draftTable.whenCreatedColumn = this.whenCreatedColumn;
        this.draftTable.identityMode = this.identityMode;
        for (MColumn col : this.allColumns()) {
            this.draftTable.addColumn(col.copyForDraft());
        }
        return this.draftTable;
    }

    public MTable(CreateTable createTable) {
        this.name = createTable.getName();
        this.pkName = createTable.getPkName();
        this.comment = createTable.getComment();
        this.storageEngine = createTable.getStorageEngine();
        this.tablespaceMeta = createTable.getTablespace() != null ? new TablespaceMeta(createTable.getTablespace(), createTable.getIndexTablespace() != null ? createTable.getIndexTablespace() : createTable.getTablespace(), createTable.getLobTablespace() != null ? createTable.getLobTablespace() : createTable.getTablespace()) : null;
        this.withHistory = Boolean.TRUE.equals(createTable.isWithHistory());
        this.draft = Boolean.TRUE.equals(createTable.isDraft());
        this.identityMode = MTableIdentity.fromCreateTable(createTable);
        List<Column> cols = createTable.getColumn();
        for (Column column : cols) {
            this.addColumn(column);
        }
        for (UniqueConstraint uq : createTable.getUniqueConstraint()) {
            this.uniqueConstraints.add(new MCompoundUniqueConstraint(uq));
        }
        for (ForeignKey fk : createTable.getForeignKey()) {
            if (DdlHelp.isDropForeignKey(fk.getColumnNames())) {
                this.removeForeignKey(fk.getName());
                continue;
            }
            this.addForeignKey(fk.getName(), fk.getRefTableName(), fk.getIndexName(), fk.getColumnNames(), fk.getRefColumnNames());
        }
    }

    public void addForeignKey(String name, String refTableName, String indexName, String columnNames, String refColumnNames) {
        MCompoundForeignKey foreignKey = new MCompoundForeignKey(name, refTableName, indexName);
        String[] cols = SplitColumns.split(columnNames);
        String[] refCols = SplitColumns.split(refColumnNames);
        for (int i = 0; i < cols.length && i < refCols.length; ++i) {
            foreignKey.addColumnPair(cols[i], refCols[i]);
        }
        this.addForeignKey(foreignKey);
    }

    public DropTable dropTable() {
        DropTable dropTable = new DropTable();
        dropTable.setName(this.name);
        if (this.identityMode.isDatabaseIdentity()) {
            String pkCol = null;
            for (MColumn column : this.columns.values()) {
                if (!column.isPrimaryKey()) continue;
                if (pkCol == null) {
                    pkCol = column.getName();
                    continue;
                }
                pkCol = null;
                break;
            }
            if (pkCol != null) {
                dropTable.setSequenceCol(pkCol);
                dropTable.setSequenceName(this.identityMode.getSequenceName());
            }
        }
        return dropTable;
    }

    public CreateTable createTable() {
        CreateTable createTable = new CreateTable();
        createTable.setName(this.name);
        createTable.setPkName(this.pkName);
        createTable.setComment(this.comment);
        if (this.partitionMeta != null) {
            createTable.setPartitionMode(this.partitionMeta.getMode().name());
            createTable.setPartitionColumn(this.partitionMeta.getProperty());
        }
        createTable.setStorageEngine(this.storageEngine);
        if (this.tablespaceMeta != null) {
            createTable.setTablespace(this.tablespaceMeta.getTablespaceName());
            createTable.setIndexTablespace(this.tablespaceMeta.getIndexTablespace());
            createTable.setLobTablespace(this.tablespaceMeta.getLobTablespace());
        }
        MTableIdentity.toCreateTable(this.identityMode, createTable);
        if (this.withHistory) {
            createTable.setWithHistory(Boolean.TRUE);
        }
        if (this.draft) {
            createTable.setDraft(Boolean.TRUE);
        }
        for (MColumn column : this.allColumns()) {
            if (!this.draft && column.isDraftOnly()) continue;
            createTable.getColumn().add(column.createColumn());
        }
        for (MCompoundForeignKey compoundKey : this.compoundKeys) {
            createTable.getForeignKey().add(compoundKey.createForeignKey());
        }
        for (MCompoundUniqueConstraint constraint : this.uniqueConstraints) {
            createTable.getUniqueConstraint().add(constraint.getUniqueConstraint());
        }
        return createTable;
    }

    public void compare(ModelDiff modelDiff, MTable newTable) {
        if (this.withHistory != newTable.withHistory) {
            if (this.withHistory) {
                DropHistoryTable dropHistoryTable = new DropHistoryTable();
                dropHistoryTable.setBaseTable(this.name);
                modelDiff.addDropHistoryTable(dropHistoryTable);
            } else {
                AddHistoryTable addHistoryTable = new AddHistoryTable();
                addHistoryTable.setBaseTable(this.name);
                modelDiff.addAddHistoryTable(addHistoryTable);
            }
        }
        this.compareColumns(modelDiff, newTable);
        if (MColumn.different(this.comment, newTable.comment)) {
            AddTableComment addTableComment = new AddTableComment();
            addTableComment.setName(this.name);
            if (newTable.comment == null) {
                addTableComment.setComment("DROP COMMENT");
            } else {
                addTableComment.setComment(newTable.comment);
            }
            modelDiff.addTableComment(addTableComment);
        }
        this.compareCompoundKeys(modelDiff, newTable);
        this.compareUniqueKeys(modelDiff, newTable);
        this.compareTableAttrs(modelDiff, newTable);
    }

    private void compareColumns(ModelDiff modelDiff, MTable newTable) {
        this.addColumn = null;
        Map<String, MColumn> newColumnMap = newTable.getColumns();
        for (MColumn newColumn : newColumnMap.values()) {
            MColumn localColumn = this.getColumn(newColumn.getName());
            if (localColumn == null) {
                if (newColumn.isDraftOnly() && !this.draft) continue;
                this.diffNewColumn(newColumn, newTable);
                continue;
            }
            localColumn.compare(modelDiff, this, newColumn);
        }
        for (MColumn existingColumn : this.allColumns()) {
            MColumn newColumn = newColumnMap.get(existingColumn.getName());
            if (newColumn == null) {
                this.diffDropColumn(modelDiff, existingColumn);
                continue;
            }
            if (!newColumn.isDraftOnly() || this.draft) continue;
            logger.trace("... drop column {} from table {} as now draftOnly", (Object)newColumn.getName(), (Object)this.name);
            this.diffDropColumn(modelDiff, existingColumn);
        }
        if (this.addColumn != null) {
            modelDiff.addAddColumn(this.addColumn);
        }
    }

    private void compareCompoundKeys(ModelDiff modelDiff, MTable newTable) {
        ArrayList<MCompoundForeignKey> newKeys = new ArrayList<MCompoundForeignKey>(newTable.getCompoundKeys());
        ArrayList<MCompoundForeignKey> currentKeys = new ArrayList<MCompoundForeignKey>(this.getCompoundKeys());
        currentKeys.removeAll(newTable.getCompoundKeys());
        newKeys.removeAll(this.getCompoundKeys());
        for (MCompoundForeignKey currentKey : currentKeys) {
            modelDiff.addAlterForeignKey(currentKey.dropForeignKey(this.name));
        }
        for (MCompoundForeignKey newKey : newKeys) {
            modelDiff.addAlterForeignKey(newKey.addForeignKey(this.name));
        }
    }

    private void compareUniqueKeys(ModelDiff modelDiff, MTable newTable) {
        ArrayList<MCompoundUniqueConstraint> newKeys = new ArrayList<MCompoundUniqueConstraint>(newTable.getUniqueConstraints());
        ArrayList<MCompoundUniqueConstraint> currentKeys = new ArrayList<MCompoundUniqueConstraint>(this.getUniqueConstraints());
        currentKeys.removeAll(newTable.getUniqueConstraints());
        newKeys.removeAll(this.getUniqueConstraints());
        for (MCompoundUniqueConstraint currentKey : currentKeys) {
            modelDiff.addUniqueConstraint(currentKey.dropUniqueConstraint(this.name));
        }
        for (MCompoundUniqueConstraint newKey : newKeys) {
            modelDiff.addUniqueConstraint(newKey.addUniqueConstraint(this.name));
        }
    }

    private void compareTableAttrs(ModelDiff modelDiff, MTable newTable) {
        AlterTable alterTable = new AlterTable();
        alterTable.setName(newTable.getName());
        boolean altered = false;
        if (!Objects.equals(this.tablespaceMeta, newTable.getTablespaceMeta())) {
            if (newTable.getTablespaceMeta() == null) {
                alterTable.setTablespace("$TABLESPACE_DEFAULT");
                alterTable.setIndexTablespace("$TABLESPACE_DEFAULT");
                alterTable.setLobTablespace("$TABLESPACE_DEFAULT");
            } else {
                alterTable.setTablespace(newTable.getTablespaceMeta().getTablespaceName());
                alterTable.setIndexTablespace(newTable.getTablespaceMeta().getIndexTablespace());
                alterTable.setLobTablespace(newTable.getTablespaceMeta().getLobTablespace());
            }
            altered = true;
        }
        if (altered) {
            modelDiff.addAlterTable(alterTable);
        }
    }

    public void apply(AddColumn addColumn) {
        this.checkTableName(addColumn.getTableName());
        for (Column column : addColumn.getColumn()) {
            this.addColumn(column);
        }
    }

    public void apply(AlterColumn alterColumn) {
        this.checkTableName(alterColumn.getTableName());
        String columnName = alterColumn.getColumnName();
        MColumn existingColumn = this.getColumn(columnName);
        if (existingColumn == null) {
            throw new IllegalStateException("Column [" + columnName + "] does not exist for AlterColumn change?");
        }
        existingColumn.apply(alterColumn);
    }

    public void apply(DropColumn dropColumn) {
        this.checkTableName(dropColumn.getTableName());
        MColumn removed = this.columns.remove(dropColumn.getColumnName());
        if (removed == null) {
            throw new IllegalStateException("Column [" + dropColumn.getColumnName() + "] does not exist for DropColumn change on table [" + dropColumn.getTableName() + "]?");
        }
    }

    public void apply(RenameColumn renameColumn) {
        this.checkTableName(renameColumn.getTableName());
        MColumn column = this.columns.remove(renameColumn.getOldName());
        if (column == null) {
            throw new IllegalStateException("Column [" + renameColumn.getOldName() + "] does not exist for RenameColumn change on table [" + renameColumn.getTableName() + "]?");
        }
        this.addColumn(column.rename(renameColumn.getNewName()));
    }

    public void apply(RenameTable renameTable) {
        this.checkTableName(renameTable.getOldName());
        this.name = renameTable.getNewName();
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        int pos = this.name.indexOf(46);
        return pos == -1 ? null : this.name.substring(0, pos);
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isPartitioned() {
        return this.partitionMeta != null;
    }

    public PartitionMeta getPartitionMeta() {
        return this.partitionMeta;
    }

    public String getPkName() {
        return this.pkName;
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTablespaceMeta(TablespaceMeta tablespaceMeta) {
        this.tablespaceMeta = tablespaceMeta;
    }

    public TablespaceMeta getTablespaceMeta() {
        return this.tablespaceMeta;
    }

    public boolean isWithHistory() {
        return this.withHistory;
    }

    public MTable setWithHistory(boolean withHistory) {
        this.withHistory = withHistory;
        return this;
    }

    public List<String> allHistoryColumns(boolean includeDropped) {
        ArrayList<String> columnNames = new ArrayList<String>(this.columns.size());
        for (MColumn column : this.columns.values()) {
            if (!column.isIncludeInHistory()) continue;
            columnNames.add(column.getName());
        }
        if (includeDropped && !this.droppedColumns.isEmpty()) {
            columnNames.addAll(this.droppedColumns);
        }
        return columnNames;
    }

    public boolean hasDroppedColumns() {
        return !this.droppedColumns.isEmpty();
    }

    public Collection<MColumn> allColumns() {
        return this.columns.values();
    }

    public MColumn getColumn(String name) {
        return this.columns.get(name);
    }

    private Map<String, MColumn> getColumns() {
        return this.columns;
    }

    public List<MCompoundUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public List<MCompoundForeignKey> getCompoundKeys() {
        return this.compoundKeys;
    }

    public String getWhenCreatedColumn() {
        return this.whenCreatedColumn;
    }

    public List<MColumn> primaryKeyColumns() {
        ArrayList<MColumn> pk = new ArrayList<MColumn>(3);
        for (MColumn column : this.allColumns()) {
            if (!column.isPrimaryKey()) continue;
            pk.add(column);
        }
        return pk;
    }

    public String singlePrimaryKey() {
        List<MColumn> columns = this.primaryKeyColumns();
        if (columns.size() == 1) {
            return columns.get(0).getName();
        }
        return null;
    }

    private void checkTableName(String tableName) {
        if (!this.name.equals(tableName)) {
            throw new IllegalArgumentException("tableName [" + tableName + "] does not match [" + this.name + "]");
        }
    }

    private void addColumn(Column column) {
        this.columns.put(column.getName(), new MColumn(column));
    }

    public void addColumn(MColumn column) {
        this.columns.put(column.getName(), column);
    }

    public void addUniqueConstraint(MCompoundUniqueConstraint uniqueConstraint) {
        this.uniqueConstraints.add(uniqueConstraint);
    }

    public void addForeignKey(MCompoundForeignKey compoundKey) {
        this.compoundKeys.add(compoundKey);
    }

    public MColumn addColumn(String dbCol, String columnDefn, boolean notnull) {
        MColumn existingColumn = this.getColumn(dbCol);
        if (existingColumn != null) {
            if (notnull) {
                existingColumn.setNotnull(true);
            }
            return existingColumn;
        }
        MColumn newCol = new MColumn(dbCol, columnDefn, notnull);
        this.addColumn(newCol);
        return newCol;
    }

    public MColumn addColumnScalar(String dbColumn, String columnDefn) {
        MColumn existingColumn = this.getColumn(dbColumn);
        if (existingColumn != null) {
            return existingColumn;
        }
        MColumn newCol = new MColumn(dbColumn, columnDefn);
        this.addColumn(newCol);
        return newCol;
    }

    private void diffNewColumn(MColumn newColumn, MTable newTable) {
        if (this.addColumn == null) {
            this.addColumn = new AddColumn();
            this.addColumn.setTableName(this.name);
            if (newTable.isWithHistory()) {
                this.addColumn.setWithHistory(Boolean.TRUE);
            }
        }
        this.addColumn.getColumn().add(newColumn.createColumn());
    }

    private void diffDropColumn(ModelDiff modelDiff, MColumn existingColumn) {
        DropColumn dropColumn = new DropColumn();
        dropColumn.setTableName(this.name);
        dropColumn.setColumnName(existingColumn.getName());
        if (this.withHistory) {
            dropColumn.setWithHistory(Boolean.TRUE);
        }
        modelDiff.addDropColumn(dropColumn);
    }

    public void registerPendingDropColumn(String columnName) {
        this.droppedColumns.add(columnName);
    }

    public void checkDuplicateForeignKeys() {
        if (this.hasDuplicateForeignKeys()) {
            int counter = 1;
            for (MCompoundForeignKey fk : this.compoundKeys) {
                fk.addNameSuffix(counter++);
            }
        }
    }

    private boolean hasDuplicateForeignKeys() {
        HashSet<String> fkNames = new HashSet<String>();
        for (MCompoundForeignKey fk : this.compoundKeys) {
            if (fkNames.add(fk.getName())) continue;
            return true;
        }
        return false;
    }

    public void adjustReferences(ModelContainer modelContainer) {
        Collection<MColumn> cols = this.allColumns();
        for (MColumn col : cols) {
            String references = col.getReferences();
            if (references == null) continue;
            String baseTable = this.extractBaseTable(references);
            MTable refBaseTable = modelContainer.getTable(baseTable);
            if (refBaseTable.draftTable == null) continue;
            String newReferences = this.deriveReferences(references, refBaseTable.draftTable.getName());
            col.setReferences(newReferences);
        }
    }

    private String extractBaseTable(String references) {
        int lastDot = references.lastIndexOf(46);
        return references.substring(0, lastDot);
    }

    private String deriveReferences(String references, String draftTableName) {
        int lastDot = references.lastIndexOf(46);
        return draftTableName + "." + references.substring(lastDot + 1);
    }

    public void updateCompoundIndices() {
        for (MCompoundUniqueConstraint uniq : this.uniqueConstraints) {
            ArrayList<String> nullableColumns = new ArrayList<String>();
            for (String columnName : uniq.getColumns()) {
                MColumn col = this.getColumn(columnName);
                if (col == null || col.isNotnull()) continue;
                nullableColumns.add(columnName);
            }
            uniq.setNullableColumns(nullableColumns.toArray(new String[0]));
        }
    }

    public void removeForeignKey(String name) {
        this.compoundKeys.removeIf(fk -> fk.getName().equals(name));
    }

    public void clearForeignKeyIndexes() {
        for (MCompoundForeignKey compoundKey : this.compoundKeys) {
            compoundKey.setIndexName(null);
        }
    }

    public MIndex setReusedElementCollection() {
        MIndex index = null;
        for (MColumn column : this.columns.values()) {
            String references = column.getReferences();
            if (references == null) continue;
            index = new MIndex(column.getForeignKeyIndex(), this.name, column.getName());
            column.clearForeignKey();
        }
        return index;
    }
}

