/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbConstraintNaming;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;

public abstract class DbTableBasedHistoryDdl
implements PlatformHistoryDdl.TableBased {
    private DbConstraintNaming constraintNaming;
    private String historySuffix;
    protected PlatformDdl platformDdl;

    @Override
    public void configure(DatabaseConfig config, PlatformDdl platformDdl) {
        this.platformDdl = platformDdl;
        this.historySuffix = config.getHistoryTableSuffix();
        this.constraintNaming = config.getConstraintNaming();
    }

    @Override
    public String historyTableName(String baseTableName) {
        return this.normalise(baseTableName, this.historySuffix);
    }

    protected String normalise(String tableName, String suffix) {
        String normalized = this.quote(this.normalise(tableName) + suffix);
        int lastPeriod = tableName.lastIndexOf(46);
        return tableName.substring(0, lastPeriod + 1) + normalized;
    }

    protected String normalise(String tableName) {
        return this.constraintNaming.normaliseTable(tableName);
    }

    protected String quote(String dbName) {
        return this.platformDdl.quote(dbName);
    }
}

