/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import java.util.ArrayList;
import java.util.List;

public class HistoryTableUpdate {
    private final String baseTable;
    private final List<Column> columnChanges = new ArrayList<Column>();

    public HistoryTableUpdate(String baseTable) {
        this.baseTable = baseTable;
    }

    public String description() {
        return this.columnChanges.toString();
    }

    public void add(Change change, String column) {
        this.columnChanges.add(new Column(change, column));
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    private static class Column {
        final Change change;
        final String column;

        public Column(Change change, String column) {
            this.change = change;
            this.column = column;
        }

        public String toString() {
            return this.description();
        }

        public String description() {
            return this.change.name().toLowerCase() + " " + this.column;
        }
    }

    public static enum Change {
        ADD,
        DROP,
        INCLUDE,
        EXCLUDE,
        ALTER;

    }
}

