/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration;

import io.ebean.migration.MigrationVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

class LastMigration {
    private static final String SQL = ".sql";
    private static final String MODEL_XML = ".model.xml";

    LastMigration() {
    }

    static String nextVersion(File migDir, File modelDir, boolean dbinitMigration) {
        String last = LastMigration.lastVersion(migDir, modelDir);
        if (last == null) {
            return null;
        }
        return dbinitMigration ? last : MigrationVersion.parse((String)last).nextVersion();
    }

    static String lastVersion(File migDirectory, File modelDir) {
        File[] xmlFiles;
        ArrayList<MigrationVersion> versions = new ArrayList<MigrationVersion>();
        File[] sqlFiles = migDirectory.listFiles(pathname -> LastMigration.includeSqlFile(pathname.getName().toLowerCase()));
        if (sqlFiles != null) {
            for (File file : sqlFiles) {
                versions.add(LastMigration.trimAndParse(file.getName()));
            }
        }
        if (modelDir != null && (xmlFiles = modelDir.listFiles(pathname -> LastMigration.includeModelFile(pathname.getName().toLowerCase()))) != null) {
            for (File file : xmlFiles) {
                versions.add(LastMigration.trimAndParse(file.getName()));
            }
        }
        Collections.sort(versions);
        if (!versions.isEmpty()) {
            return ((MigrationVersion)versions.get(versions.size() - 1)).asString();
        }
        return null;
    }

    private static boolean includeSqlFile(String lowerFileName) {
        return !lowerFileName.startsWith("r") && !lowerFileName.startsWith("i") && lowerFileName.endsWith(SQL);
    }

    private static boolean includeModelFile(String lowerFileName) {
        return lowerFileName.endsWith(MODEL_XML);
    }

    private static MigrationVersion trimAndParse(String name) {
        if (name.endsWith(SQL)) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.endsWith(MODEL_XML)) {
            name = name.substring(0, name.length() - 10);
        }
        return MigrationVersion.parse((String)name);
    }
}

