/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.CountMetric;
import io.ebean.metric.CountMetricStats;
import java.util.concurrent.atomic.LongAdder;

final class DCountMetric
implements CountMetric {
    private final String name;
    private final LongAdder count = new LongAdder();
    private String reportName;

    DCountMetric(String name) {
        this.name = name;
    }

    public void add(long value) {
        this.count.add(value);
    }

    public void increment() {
        this.count.increment();
    }

    public boolean isEmpty() {
        return this.count.sum() == 0L;
    }

    public void reset() {
        this.count.reset();
    }

    public long get(boolean reset) {
        return reset ? this.count.sumThenReset() : this.count.sum();
    }

    public void visit(MetricVisitor visitor) {
        long val;
        long l = val = visitor.reset() ? this.count.sumThenReset() : this.count.sum();
        if (val > 0L) {
            String name = this.reportName != null ? this.reportName : this.reportName(visitor);
            visitor.visitCount((MetaCountMetric)new DCountMetricStats(name, val));
        }
    }

    String reportName(MetricVisitor visitor) {
        String tmp;
        this.reportName = tmp = (String)visitor.namingConvention().apply(this.name);
        return tmp;
    }

    private static class DCountMetricStats
    implements CountMetricStats {
        private final String name;
        private final long count;

        private DCountMetricStats(String name, long count) {
            this.name = name;
            this.count = count;
        }

        public String name() {
            return this.name;
        }

        public long count() {
            return this.count;
        }
    }
}

