/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.meta.MetricVisitor;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.TimedMetricMap;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequestCallableSql;
import io.ebeaninternal.server.core.PersistRequestOrmUpdate;
import io.ebeaninternal.server.core.PersistRequestUpdateSql;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.persist.ExeCallableSql;
import io.ebeaninternal.server.persist.ExeOrmUpdate;
import io.ebeaninternal.server.persist.ExeUpdateSql;
import io.ebeaninternal.server.persist.PersistExecute;

final class DefaultPersistExecute
implements PersistExecute {
    private final ExeCallableSql exeCallableSql;
    private final ExeUpdateSql exeUpdateSql;
    private final ExeOrmUpdate exeOrmUpdate;
    private final int defaultBatchSize;
    private final TimedMetricMap ormUpdateMetric;
    private final TimedMetricMap sqlUpdateMetric;
    private final TimedMetricMap sqlCallMetric;

    DefaultPersistExecute(Binder binder, int defaultBatchSize) {
        this.exeOrmUpdate = new ExeOrmUpdate(binder);
        this.exeUpdateSql = new ExeUpdateSql(binder);
        this.exeCallableSql = new ExeCallableSql(binder);
        this.defaultBatchSize = defaultBatchSize;
        this.ormUpdateMetric = MetricFactory.get().createTimedMetricMap("orm.update.");
        this.sqlUpdateMetric = MetricFactory.get().createTimedMetricMap("sql.update.");
        this.sqlCallMetric = MetricFactory.get().createTimedMetricMap("sql.call.");
    }

    @Override
    public void visitMetrics(MetricVisitor visitor) {
        this.ormUpdateMetric.visit(visitor);
        this.sqlUpdateMetric.visit(visitor);
        this.sqlCallMetric.visit(visitor);
    }

    @Override
    public void collectOrmUpdate(String label, long startNanos) {
        this.ormUpdateMetric.addSinceNanos(label, startNanos);
    }

    @Override
    public void collectSqlUpdate(String label, long startNanos) {
        this.sqlUpdateMetric.addSinceNanos(label, startNanos);
    }

    @Override
    public void collectSqlCall(String label, long startNanos) {
        this.sqlCallMetric.addSinceNanos(label, startNanos);
    }

    @Override
    public BatchControl createBatchControl(SpiTransaction t) {
        return new BatchControl(t, this.defaultBatchSize, true);
    }

    @Override
    public int executeOrmUpdate(PersistRequestOrmUpdate request) {
        return this.exeOrmUpdate.execute(request);
    }

    @Override
    public int executeSqlUpdate(PersistRequestUpdateSql request) {
        return this.exeUpdateSql.execute(request);
    }

    @Override
    public int executeSqlCallable(PersistRequestCallableSql request) {
        return this.exeCallableSql.execute(request);
    }
}

