/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression.platform;

import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.server.expression.platform.BasicDbExpression;
import io.ebeaninternal.server.expression.platform.Db2DbExpression;
import io.ebeaninternal.server.expression.platform.DbExpressionHandler;
import io.ebeaninternal.server.expression.platform.H2DbExpression;
import io.ebeaninternal.server.expression.platform.HanaDbExpression;
import io.ebeaninternal.server.expression.platform.MariaDbExpression;
import io.ebeaninternal.server.expression.platform.MySqlDbExpression;
import io.ebeaninternal.server.expression.platform.OracleDbExpression;
import io.ebeaninternal.server.expression.platform.PostgresDbExpression;
import io.ebeaninternal.server.expression.platform.SqlServerDbExpression;

public final class DbExpressionHandlerFactory {
    public static DbExpressionHandler from(DatabasePlatform databasePlatform) {
        Platform platform = databasePlatform.getPlatform().base();
        switch (platform) {
            case H2: {
                return new H2DbExpression();
            }
            case POSTGRES: 
            case YUGABYTE: 
            case COCKROACH: {
                return new PostgresDbExpression();
            }
            case MARIADB: {
                return new MariaDbExpression();
            }
            case MYSQL: {
                return new MySqlDbExpression();
            }
            case ORACLE: {
                return new OracleDbExpression();
            }
            case DB2: {
                return new Db2DbExpression();
            }
            case SQLSERVER: {
                return new SqlServerDbExpression();
            }
            case HANA: {
                return new HanaDbExpression();
            }
        }
        return new BasicDbExpression();
    }
}

