/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.EnumToDbValueMap;
import io.ebeaninternal.server.type.ScalarTypeEnum;
import io.ebeaninternal.server.type.ScalarTypeEnumStandard;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EnumType;

class ScalarTypeEnumWithMapping
extends ScalarTypeEnumStandard.EnumBase
implements ScalarType,
ScalarTypeEnum {
    private final EnumToDbValueMap beanDbMap;
    private final int length;
    private final boolean withConstraint;

    ScalarTypeEnumWithMapping(EnumToDbValueMap<?> beanDbMap, Class<?> enumType, int length, boolean withConstraint) {
        super(enumType, false, beanDbMap.getDbType());
        this.beanDbMap = beanDbMap;
        this.length = length;
        this.withConstraint = withConstraint;
    }

    ScalarTypeEnumWithMapping(EnumToDbValueMap<?> beanDbMap, Class<?> enumType, int length) {
        this(beanDbMap, enumType, length, true);
    }

    @Override
    public boolean isCompatible(EnumType enumType) {
        return enumType == null;
    }

    @Override
    public Set<String> getDbCheckConstraintValues() {
        if (!this.withConstraint) {
            return null;
        }
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        Iterator it = this.beanDbMap.dbValues();
        while (it.hasNext()) {
            Object dbValue = it.next();
            if (this.beanDbMap.isIntegerType()) {
                values.add(dbValue.toString());
                continue;
            }
            values.add("'" + dbValue.toString() + "'");
        }
        return values;
    }

    public int getLength() {
        return this.length;
    }

    public void bind(DataBinder binder, Object value) throws SQLException {
        this.beanDbMap.bind(binder, value);
    }

    public Object read(DataReader reader) throws SQLException {
        return this.beanDbMap.read(reader);
    }

    public Object toBeanType(Object dbValue) {
        if (dbValue == null || dbValue instanceof Enum) {
            return dbValue;
        }
        return this.beanDbMap.getBeanValue(dbValue);
    }

    public Object toJdbcType(Object beanValue) {
        return this.beanDbMap.getDbValue(beanValue);
    }
}

