/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.util.SplitName;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

final class IsEmptyExpression
extends AbstractExpression {
    private final boolean empty;
    private final String propertyPath;
    private String nestedPath;

    IsEmptyExpression(String propertyName, boolean empty) {
        super(propertyName);
        this.empty = empty;
        this.propertyPath = SplitName.split((String)propertyName)[0];
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        if (this.empty) {
            this.nestedPath = this.propertyNestedPath(this.propName, desc);
            return null;
        }
        return super.nestedPath(desc);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (this.nestedPath == null) {
            context.writeExists(!this.empty, this.propName);
        } else {
            context.startBoolMustNot();
            context.startNested(this.nestedPath);
            context.writeExists(this.empty, this.propName);
            context.endNested();
            context.endBool();
        }
    }

    public String getPropName() {
        return this.propName;
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        this.propertyContainsMany(this.propertyPath, desc, manyWhereJoin);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop == null) {
            throw new IllegalStateException("Property [" + this.propName + "] not found");
        }
        IsEmptyExpression.isEmptySql(request, prop, this.empty, this.propertyPath);
    }

    static void isEmptySql(SpiExpressionRequest request, ElPropertyValue prop, boolean empty, String propertyPath) {
        if (empty) {
            request.append("not ");
        }
        request.append("exists (select 1 from ").append(prop.assocIsEmpty(request, propertyPath)).append(")");
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        if (this.empty) {
            builder.append("IsEmpty[");
        } else {
            builder.append("IsNotEmpty[");
        }
        builder.append(this.propName).append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        return other instanceof IsEmptyExpression;
    }
}

