/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebean.meta.MetricVisitor;
import io.ebeaninternal.server.dto.DtoBeanDescriptor;
import io.ebeaninternal.server.dto.DtoMeta;
import io.ebeaninternal.server.dto.DtoMetaBuilder;
import io.ebeaninternal.server.dto.DtoNamedQueries;
import io.ebeaninternal.server.type.TypeManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DtoBeanManager {
    private static final Map<String, String> EMPTY_NAMED_QUERIES = new HashMap<String, String>();
    private final TypeManager typeManager;
    private final Map<Class<?>, DtoNamedQueries> namedQueries;
    private final Map<Class, DtoBeanDescriptor> descriptorMap = new ConcurrentHashMap<Class, DtoBeanDescriptor>();

    public DtoBeanManager(TypeManager typeManager, Map<Class<?>, DtoNamedQueries> namedQueries) {
        this.typeManager = typeManager;
        this.namedQueries = namedQueries;
    }

    public <T> DtoBeanDescriptor<T> getDescriptor(Class<T> dtoType) {
        return this.descriptorMap.computeIfAbsent(dtoType, this::createDescriptor);
    }

    private <T> DtoBeanDescriptor createDescriptor(Class<T> dtoType) {
        try {
            DtoMeta meta = new DtoMetaBuilder(dtoType, this.typeManager).build();
            return new DtoBeanDescriptor<T>(dtoType, meta, this.namedQueries(dtoType));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private <T> Map<String, String> namedQueries(Class<T> dtoType) {
        DtoNamedQueries namedQueries = this.namedQueries.get(dtoType);
        return namedQueries == null ? EMPTY_NAMED_QUERIES : namedQueries.map();
    }

    public void visitMetrics(MetricVisitor visitor) {
        for (DtoBeanDescriptor value : this.descriptorMap.values()) {
            value.visit(visitor);
        }
    }
}

