/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.Database;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.timezone.DataTimeZone;

public abstract class BeanRequest {
    protected final SpiEbeanServer server;
    protected SpiTransaction transaction;
    protected boolean createdTransaction;

    public BeanRequest(SpiEbeanServer server, SpiTransaction transaction) {
        this.server = server;
        this.transaction = transaction;
    }

    public boolean createImplicitTransIfRequired() {
        if (this.transaction != null) {
            return false;
        }
        this.transaction = this.server.currentServerTransaction();
        if (this.transaction == null || !this.transaction.isActive()) {
            this.transaction = this.server.beginServerTransaction();
            this.createdTransaction = true;
        }
        return true;
    }

    public void commitTransIfRequired() {
        if (this.createdTransaction) {
            this.server.commitTransaction();
        }
    }

    public void rollbackTransIfRequired() {
        if (this.createdTransaction) {
            try {
                this.server.endTransaction();
            }
            catch (Exception e) {
                CoreLog.log.error("Error trying to rollback a transaction (after a prior exception thrown)", (Throwable)e);
            }
        }
    }

    public void clearTransIfRequired() {
        if (this.createdTransaction) {
            this.server.clearServerTransaction();
        }
    }

    public Database database() {
        return this.server;
    }

    public SpiEbeanServer server() {
        return this.server;
    }

    public SpiTransaction transaction() {
        return this.transaction;
    }

    public void transaction(SpiTransaction transaction) {
        this.transaction = transaction;
    }

    public boolean logSql() {
        return this.transaction.isLogSql();
    }

    public boolean logSummary() {
        return this.transaction.isLogSummary();
    }

    public DataTimeZone dataTimeZone() {
        return this.server.dataTimeZone();
    }
}

