/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.avaje.lang.NonNullApi;
import io.ebean.DtoQuery;
import io.ebean.ProfileLocation;
import io.ebean.QueryIterator;
import io.ebean.Transaction;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiDtoQuery;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.dto.DtoBeanDescriptor;
import io.ebeaninternal.server.dto.DtoMappingRequest;
import io.ebeaninternal.server.dto.DtoQueryPlan;
import io.ebeaninternal.server.querydefn.AbstractQuery;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@NonNullApi
public final class DefaultDtoQuery<T>
extends AbstractQuery
implements SpiDtoQuery<T> {
    private final SpiEbeanServer server;
    private final DtoBeanDescriptor<T> descriptor;
    private final SpiQuery<?> ormQuery;
    private String sql;
    private int firstRow;
    private int maxRows;
    private int timeout;
    private int bufferFetchSizeHint;
    private boolean relaxedMode;
    private String label;
    private ProfileLocation profileLocation;
    private final BindParams bindParams = new BindParams();
    private Transaction transaction;

    public DefaultDtoQuery(SpiEbeanServer server, DtoBeanDescriptor<T> descriptor, SpiQuery<?> ormQuery) {
        this.server = server;
        this.descriptor = descriptor;
        this.ormQuery = ormQuery;
        this.label = ormQuery.getLabel();
        this.profileLocation = ormQuery.getProfileLocation();
    }

    public DefaultDtoQuery(SpiEbeanServer server, DtoBeanDescriptor<T> descriptor, String sql) {
        this.server = server;
        this.descriptor = descriptor;
        this.ormQuery = null;
        this.sql = sql;
    }

    @Override
    public String planKey() {
        return this.sql + ":first" + this.firstRow + ":max" + this.maxRows;
    }

    @Override
    public DtoQueryPlan getQueryPlan(Object planKey) {
        return this.descriptor.getQueryPlan(planKey);
    }

    @Override
    public DtoQueryPlan buildPlan(DtoMappingRequest request) {
        return this.descriptor.buildPlan(request);
    }

    @Override
    public void putQueryPlan(Object planKey, DtoQueryPlan plan) {
        this.descriptor.putQueryPlan(planKey, plan);
    }

    public DtoQuery<T> usingTransaction(Transaction transaction) {
        this.transaction = transaction;
        return this;
    }

    public void findEach(Consumer<T> consumer) {
        this.server.findDtoEach(this, consumer);
    }

    public void findEach(int batch, Consumer<List<T>> consumer) {
        this.server.findDtoEach(this, batch, consumer);
    }

    public void findEachWhile(Predicate<T> consumer) {
        this.server.findDtoEachWhile(this, consumer);
    }

    public QueryIterator<T> findIterate() {
        return this.server.findDtoIterate(this);
    }

    public Stream<T> findStream() {
        return this.server.findDtoStream(this);
    }

    public List<T> findList() {
        return this.server.findDtoList(this);
    }

    @Nullable
    public T findOne() {
        return this.server.findDtoOne(this);
    }

    public Optional<T> findOneOrEmpty() {
        return Optional.ofNullable(this.findOne());
    }

    public DtoQuery<T> setParameter(int position, Object value) {
        if (this.ormQuery != null) {
            this.ormQuery.setParameter(position, value);
        } else {
            this.bindParams.setParameter(position, value);
        }
        return this;
    }

    public DtoQuery<T> setParameter(String paramName, Object value) {
        if (this.ormQuery != null) {
            this.ormQuery.setParameter(paramName, value);
        } else {
            this.bindParams.setParameter(paramName, value);
        }
        return this;
    }

    public DtoQuery<T> setArrayParameter(String paramName, Collection<?> values) {
        if (this.ormQuery != null) {
            this.ormQuery.setArrayParameter(paramName, values);
        } else {
            this.bindParams.setArrayParameter(paramName, values);
        }
        return this;
    }

    public DtoQuery<T> setParameters(Object ... values) {
        if (this.ormQuery != null) {
            this.ormQuery.setParameters(values);
        } else {
            this.bindParams.setNextParameters(values);
        }
        return this;
    }

    public DtoQuery<T> setParameter(Object value) {
        if (this.ormQuery != null) {
            this.ormQuery.setParameter(value);
        } else {
            this.bindParams.setNextParameter(value);
        }
        return this;
    }

    public String toString() {
        return "DtoQuery [" + this.sql + "]";
    }

    @Override
    public Class<T> getType() {
        return this.descriptor.getType();
    }

    @Override
    public SpiQuery<?> getOrmQuery() {
        return this.ormQuery;
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    public DtoQuery<T> setRelaxedMode() {
        this.relaxedMode = true;
        return this;
    }

    @Override
    public boolean isRelaxedMode() {
        return this.relaxedMode;
    }

    public DtoQuery<T> setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    public String getPlanLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.profileLocation != null) {
            return this.profileLocation.label();
        }
        return null;
    }

    @Override
    public void obtainLocation() {
        if (this.profileLocation != null) {
            this.profileLocation.obtain();
        }
    }

    public DtoQuery<T> setProfileLocation(ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
        return this;
    }

    @Override
    public ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    @Override
    public int getFirstRow() {
        return this.firstRow;
    }

    public DtoQuery<T> setFirstRow(int firstRow) {
        this.firstRow = firstRow;
        if (this.ormQuery != null) {
            this.ormQuery.setFirstRow(firstRow);
        }
        return this;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    public DtoQuery<T> setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        if (this.ormQuery != null) {
            this.ormQuery.setMaxRows(maxRows);
        }
        return this;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public DtoQuery<T> setTimeout(int secs) {
        this.timeout = secs;
        return this;
    }

    @Override
    public BindParams getBindParams() {
        return this.bindParams;
    }

    public DtoQuery<T> setBufferFetchSizeHint(int bufferFetchSizeHint) {
        this.bufferFetchSizeHint = bufferFetchSizeHint;
        return this;
    }

    @Override
    public int getBufferFetchSizeHint() {
        return this.bufferFetchSizeHint;
    }

    @Override
    public String getQuery() {
        return this.sql;
    }
}

