/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import io.ebeaninternal.server.persist.dml.GeneratedPropertyCollector;
import java.util.List;

final class GeneratedProperties {
    private final SetValue[] onInsert;
    private final SetValue[] onUpdate;

    static GeneratedProperties of(BeanDescriptor<?> desc) {
        return new GeneratedPropertyCollector(desc).generatedProperties();
    }

    GeneratedProperties(List<BeanProperty> inserts, List<BeanProperty> updates) {
        this.onInsert = this.adapt(inserts);
        this.onUpdate = this.adapt(updates);
    }

    private SetValue[] adapt(List<BeanProperty> inserts) {
        SetValue[] setters = new SetValue[inserts.size()];
        for (int i = 0; i < inserts.size(); ++i) {
            setters[i] = new SetValue(inserts.get(i));
        }
        return setters;
    }

    public void preInsert(EntityBean bean, long now) {
        for (SetValue setter : this.onInsert) {
            setter.preInsert(bean, now);
        }
    }

    public void preUpdate(EntityBean bean, long now) {
        for (SetValue setter : this.onUpdate) {
            setter.preUpdate(bean, now);
        }
    }

    private static class SetValue {
        private final BeanProperty property;
        private final GeneratedProperty generatedProperty;

        SetValue(BeanProperty property) {
            this.property = property;
            this.generatedProperty = property.generatedProperty();
        }

        void preInsert(EntityBean bean, long now) {
            Object value = this.generatedProperty.getInsertValue(this.property, bean, now);
            this.property.setValue(bean, value);
        }

        void preUpdate(EntityBean bean, long now) {
            Object value = this.generatedProperty.getUpdateValue(this.property, bean, now);
            this.property.setValue(bean, value);
        }
    }
}

