/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.LikeType;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

final class NativeILikeExpression
extends AbstractExpression {
    private final String val;

    NativeILikeExpression(String propertyName, String value) {
        super(propertyName);
        this.val = value;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeLike(this.propName, this.val, LikeType.RAW, true);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.beanProperty().encryptKey().getStringValue();
            request.addBindEncryptKey(encryptKey);
        }
        request.addBindValue(this.val);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String pname = this.propName;
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.beanProperty().decryptProperty(this.propName);
        }
        request.append(pname).append(" ilike ?");
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("NativeILike[").append(this.propName).append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.val);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        NativeILikeExpression that = (NativeILikeExpression)other;
        return this.val.equals(that.val);
    }
}

