/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.datasource.DataSourcePool;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

final class SimpleDataSourceProvider
implements DataSourceSupplier {
    private final DataSource dataSource;
    private final DataSource readOnlyDataSource;

    SimpleDataSourceProvider(DataSource dataSource, DataSource readOnlyDataSource) {
        this.dataSource = dataSource;
        this.readOnlyDataSource = readOnlyDataSource;
    }

    @Override
    public Object currentTenantId() {
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public DataSource getReadOnlyDataSource() {
        return this.readOnlyDataSource;
    }

    @Override
    public Connection getConnection(Object tenantId) throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getReadOnlyConnection(Object tenantId) throws SQLException {
        return this.readOnlyDataSource.getConnection();
    }

    @Override
    public void shutdown(boolean deregisterDriver) {
        if (this.readOnlyDataSource instanceof DataSourcePool) {
            ((DataSourcePool)this.readOnlyDataSource).shutdown();
        }
        if (this.dataSource instanceof DataSourcePool) {
            ((DataSourcePool)this.dataSource).shutdown();
        }
    }
}

