/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.CallableSql;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiCallableSql;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.persist.PersistExecute;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.List;

public final class PersistRequestCallableSql
extends PersistRequest {
    private final SpiCallableSql callableSql;
    private int rowCount;
    private String bindLog;
    private CallableStatement cstmt;
    private BindParams bindParam;

    public PersistRequestCallableSql(SpiEbeanServer server, CallableSql cs, SpiTransaction t, PersistExecute persistExecute) {
        super(server, t, persistExecute, cs.getLabel());
        this.type = PersistRequest.Type.CALLABLESQL;
        this.callableSql = (SpiCallableSql)cs;
    }

    @Override
    public void profile(long offset, int flushCount) {
        this.profileBase("sc", offset, "", flushCount);
    }

    @Override
    public int executeOrQueue() {
        return this.executeStatement();
    }

    @Override
    public int executeNow() {
        return this.persistExecute.executeSqlCallable(this);
    }

    public SpiCallableSql callableSql() {
        return this.callableSql;
    }

    public void setBindLog(String bindLog) {
        this.bindLog = bindLog;
    }

    @Override
    public void checkRowCount(int count) {
        this.rowCount = count;
    }

    @Override
    public void setGeneratedKey(Object idValue) {
    }

    @Override
    public void postExecute() {
        TransactionEventTable tableEvents;
        if (this.startNanos > 0L) {
            this.persistExecute.collectSqlCall(this.label, this.startNanos);
        }
        if (this.transaction.isLogSummary()) {
            String m = "CallableSql label[" + this.callableSql.getLabel() + "] rows[" + this.rowCount + "] bind[" + this.bindLog + "]";
            this.transaction.logSummary(m);
        }
        if ((tableEvents = this.callableSql.getTransactionEventTable()) != null && !tableEvents.isEmpty()) {
            this.transaction.getEvent().add(tableEvents);
        } else {
            this.transaction.markNotQueryOnly();
        }
    }

    public void setBound(BindParams bindParam, CallableStatement cstmt) {
        this.bindParam = bindParam;
        this.cstmt = cstmt;
    }

    public int executeUpdate() throws SQLException {
        if (this.callableSql.executeOverride(this.cstmt)) {
            return -1;
        }
        this.rowCount = this.cstmt.executeUpdate();
        this.readOutParams();
        return this.rowCount;
    }

    private void readOutParams() throws SQLException {
        List<BindParams.Param> list = this.bindParam.positionedParameters();
        int pos = 0;
        for (BindParams.Param param : list) {
            ++pos;
            if (!param.isOutParam()) continue;
            Object outValue = this.cstmt.getObject(pos);
            param.setOutValue(outValue);
        }
    }
}

