/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cluster;

import io.ebeaninternal.api.BinaryReadContext;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.server.cluster.ServerLookup;
import io.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.io.IOException;

public class BinaryTransactionEventReader {
    private final ServerLookup serverLookup;

    public BinaryTransactionEventReader(ServerLookup serverLookup) {
        this.serverLookup = serverLookup;
    }

    public RemoteTransactionEvent read(byte[] byteData) throws IOException {
        return this.read(new BinaryReadContext(byteData));
    }

    public RemoteTransactionEvent read(BinaryReadContext dataInput) throws IOException {
        String serverName = dataInput.readUTF();
        SpiEbeanServer server = (SpiEbeanServer)this.serverLookup.getServer(serverName);
        if (server == null) {
            throw new IllegalStateException("EbeanServer not found for name [" + serverName + "]");
        }
        RemoteTransactionEvent event = new RemoteTransactionEvent(server);
        event.readBinary(dataInput);
        return event;
    }
}

