/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;

public final class CachedBeanDataToBean {
    public static void load(BeanDescriptor<?> desc, EntityBean bean, CachedBeanData cacheBeanData, PersistenceContext context) {
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        ebi.setLoadedFromCache(true);
        BeanProperty idProperty = desc.idProperty();
        if (desc.inheritInfo() != null) {
            desc = desc.inheritInfo().readType(bean.getClass()).desc();
        }
        if (idProperty != null) {
            CachedBeanDataToBean.loadProperty(bean, cacheBeanData, ebi, idProperty, context);
        }
        for (BeanProperty beanProperty : desc.propertiesNonMany()) {
            CachedBeanDataToBean.loadProperty(bean, cacheBeanData, ebi, beanProperty, context);
        }
        for (BeanProperty beanProperty : desc.propertiesMany()) {
            if (((BeanPropertyAssocMany)beanProperty).isElementCollection()) {
                CachedBeanDataToBean.loadProperty(bean, cacheBeanData, ebi, beanProperty, context);
                continue;
            }
            ((BeanPropertyAssocMany)beanProperty).createReferenceIfNull(bean);
        }
        ebi.setLoadedLazy();
    }

    private static void loadProperty(EntityBean bean, CachedBeanData cacheBeanData, EntityBeanIntercept ebi, BeanProperty prop, PersistenceContext context) {
        if (cacheBeanData.isLoaded(prop.name()) && !ebi.isLoadedProperty(prop.propertyIndex())) {
            Object value = cacheBeanData.getData(prop.name());
            prop.setCacheDataValue(bean, value, context);
        }
    }
}

