/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebeaninternal.server.type.TypeResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class TypeReflectHelper {
    public static Class<?>[] getParams(Class<?> cls, Class<?> matchRawType) {
        return TypeResolver.resolveRawArgs(matchRawType, cls);
    }

    public static Class<? extends Enum<?>> asEnumClass(Type valueType) {
        Class<?> enumClass = TypeReflectHelper.getClass(valueType);
        return enumClass;
    }

    public static boolean isEnumType(Type valueType) {
        try {
            return TypeReflectHelper.getClass(valueType).isEnum();
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return false;
        }
    }

    public static Class<?> getMapKeyType(Type genericType) {
        return TypeReflectHelper.getClass(TypeReflectHelper.getValueType(genericType));
    }

    public static Type getValueType(Type collectionType) {
        Type[] typeArgs = ((ParameterizedType)collectionType).getActualTypeArguments();
        return typeArgs[0];
    }

    private static Class<?> getClass(Type type) {
        while (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds != null && upperBounds.length == 1) {
                return TypeReflectHelper.getClass(upperBounds[0]);
            }
            throw new IllegalArgumentException("Don't know how to determine Class from Type [" + type + "]");
        }
        return (Class)type;
    }
}

