/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;

public class ScalarTypeTime
extends ScalarTypeBase<Time> {
    public ScalarTypeTime() {
        super(Time.class, true, 92);
    }

    @Override
    public void bind(DataBind b, Time value) throws SQLException {
        if (value == null) {
            b.setNull(92);
        } else {
            b.setTime(value);
        }
    }

    @Override
    public Time read(DataReader dataReader) throws SQLException {
        return dataReader.getTime();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toTime(value);
    }

    @Override
    public Time toBeanType(Object value) {
        return BasicTypeConverter.toTime(value);
    }

    @Override
    public String formatValue(Time v) {
        return v.toString();
    }

    @Override
    public Time parse(String value) {
        return Time.valueOf(value);
    }

    @Override
    public Time convertFromMillis(long systemTimeMillis) {
        return new Time(systemTimeMillis);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public Time readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        String val = dataInput.readUTF();
        return this.parse(val);
    }

    @Override
    public void writeData(DataOutput dataOutput, Time value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeUTF(this.format(value));
        }
    }

    @Override
    public Time jsonRead(JsonParser parser) throws IOException {
        return this.parse(parser.getValueAsString());
    }

    @Override
    public void jsonWrite(JsonGenerator writer, Time value) throws IOException {
        writer.writeString(this.format(value));
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.KEYWORD;
    }
}

