/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class ScalarTypeLong
extends ScalarTypeBase<Long> {
    public ScalarTypeLong() {
        super(Long.class, true, -5);
    }

    @Override
    public void bind(DataBind b, Long value) throws SQLException {
        if (value == null) {
            b.setNull(-5);
        } else {
            b.setLong(value);
        }
    }

    @Override
    public Long read(DataReader dataReader) throws SQLException {
        return dataReader.getLong();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toLong(value);
    }

    @Override
    public Long toBeanType(Object value) {
        return BasicTypeConverter.toLong(value);
    }

    @Override
    public String formatValue(Long t) {
        return t.toString();
    }

    @Override
    public Long parse(String value) {
        return Long.valueOf(value);
    }

    @Override
    public long asVersion(Long value) {
        return value;
    }

    @Override
    public Long convertFromMillis(long systemTimeMillis) {
        return systemTimeMillis;
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public Long readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readLong();
    }

    @Override
    public void writeData(DataOutput dataOutput, Long value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeLong(value);
        }
    }

    @Override
    public Long jsonRead(JsonParser parser) throws IOException {
        return parser.getLongValue();
    }

    @Override
    public void jsonWrite(JsonGenerator writer, Long value) throws IOException {
        writer.writeNumber(value.longValue());
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.LONG;
    }
}

