/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebeaninternal.json.ModifyAwareOwner;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeArray;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

abstract class ScalarTypeJsonCollection<T>
extends ScalarTypeBase<T>
implements ScalarTypeArray {
    protected final DocPropertyType docPropertyType;
    protected final boolean nullable;

    public ScalarTypeJsonCollection(Class<T> type, int dbType, DocPropertyType docPropertyType, boolean nullable) {
        super(type, false, dbType);
        this.docPropertyType = docPropertyType;
        this.nullable = nullable;
    }

    protected void bindNull(DataBind bind) throws SQLException {
        if (this.nullable) {
            bind.setNull(12);
        } else {
            bind.setString("[]");
        }
    }

    @Override
    public String getDbColumnDefn() {
        switch (this.docPropertyType) {
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return "integer[]";
            }
            case DOUBLE: 
            case FLOAT: {
                return "decimal[]";
            }
        }
        return "varchar[]";
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        return !(value instanceof ModifyAwareOwner) || ((ModifyAwareOwner)value).isMarkedDirty();
    }

    @Override
    public Object toJdbcType(Object value) {
        return value;
    }

    @Override
    public T toBeanType(Object value) {
        return (T)value;
    }

    @Override
    public DocPropertyType getDocType() {
        return this.docPropertyType;
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public T convertFromMillis(long dateTime) {
        return null;
    }

    @Override
    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    @Override
    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(value));
        }
    }
}

