/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBaseDate;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class ScalarTypeJodaLocalDate
extends ScalarTypeBaseDate<LocalDate> {
    public ScalarTypeJodaLocalDate(JsonConfig.Date mode) {
        super(mode, LocalDate.class, false, 91);
    }

    @Override
    protected String toIsoFormat(LocalDate value) {
        return value.toString();
    }

    @Override
    public LocalDate convertFromMillis(long systemTimeMillis) {
        return new LocalDate(systemTimeMillis);
    }

    @Override
    public long convertToMillis(LocalDate value) {
        return value.toDateTimeAtStartOfDay(DateTimeZone.UTC).getMillis();
    }

    @Override
    public LocalDate convertFromDate(java.sql.Date date) {
        return LocalDate.fromDateFields((Date)date);
    }

    @Override
    public java.sql.Date convertToDate(LocalDate value) {
        return new java.sql.Date(this.convertToMillis(value));
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof LocalDate) {
            return this.convertToDate((LocalDate)value);
        }
        return BasicTypeConverter.toDate(value);
    }

    @Override
    public LocalDate toBeanType(Object value) {
        if (value instanceof Date) {
            return this.convertFromMillis(((Date)value).getTime());
        }
        return (LocalDate)value;
    }
}

