/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.config.JsonConfig;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.DecimalUtils;
import io.ebeaninternal.server.type.IsoJsonDateTimeParser;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;

public abstract class ScalarTypeBaseDateTime<T>
extends ScalarTypeBase<T> {
    protected final JsonConfig.DateTime mode;

    public ScalarTypeBaseDateTime(JsonConfig.DateTime mode, Class<T> type, boolean jdbcNative, int jdbcType) {
        super(type, jdbcNative, jdbcType);
        this.mode = mode;
    }

    @Override
    public long asVersion(T value) {
        return this.convertToMillis(value);
    }

    public abstract Timestamp convertToTimestamp(T var1);

    public abstract T convertFromTimestamp(Timestamp var1);

    public abstract T convertFromInstant(Instant var1);

    @Override
    public abstract T convertFromMillis(long var1);

    public abstract long convertToMillis(T var1);

    protected abstract String toJsonNanos(T var1);

    protected abstract String toJsonISO8601(T var1);

    protected T fromJsonISO8601(String value) {
        return this.convertFromInstant(IsoJsonDateTimeParser.parseIso(value));
    }

    @Override
    public void bind(DataBind b, T value) throws SQLException {
        if (value == null) {
            b.setNull(93);
        } else {
            b.setTimestamp(this.convertToTimestamp(value));
        }
    }

    @Override
    public T read(DataReader dataReader) throws SQLException {
        Timestamp ts = dataReader.getTimestamp();
        if (ts == null) {
            return null;
        }
        return this.convertFromTimestamp(ts);
    }

    protected String toJsonNanos(long epochSecs, int nanos) {
        return DecimalUtils.toDecimal(epochSecs, nanos);
    }

    @Override
    public T jsonRead(JsonParser parser) throws IOException {
        switch (parser.getCurrentToken()) {
            case VALUE_NUMBER_INT: {
                return this.convertFromMillis(parser.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                BigDecimal value = parser.getDecimalValue();
                Timestamp timestamp = DecimalUtils.toTimestamp(value);
                return this.convertFromTimestamp(timestamp);
            }
        }
        return this.fromJsonISO8601(parser.getText());
    }

    @Override
    public void jsonWrite(JsonGenerator writer, T value) throws IOException {
        switch (this.mode) {
            case ISO8601: {
                writer.writeString(this.toJsonISO8601(value));
                break;
            }
            case NANOS: {
                writer.writeNumber(this.toJsonNanos(value));
                break;
            }
            default: {
                writer.writeNumber(this.convertToMillis(value));
            }
        }
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.DATETIME;
    }

    @Override
    public String formatValue(T value) {
        long epochMillis = this.convertToMillis(value);
        return Long.toString(epochMillis);
    }

    @Override
    public T parse(String value) {
        try {
            long epochMillis = Long.parseLong(value);
            return this.convertFromMillis(epochMillis);
        }
        catch (NumberFormatException e) {
            return this.convertFromTimestamp(Timestamp.valueOf(value));
        }
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        long val = dataInput.readLong();
        Timestamp ts = new Timestamp(val);
        return this.convertFromTimestamp(ts);
    }

    @Override
    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            Timestamp ts = this.convertToTimestamp(value);
            dataOutput.writeLong(ts.getTime());
        }
    }
}

