/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebeaninternal.server.type.ArrayElementConverter;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.PlatformArrayTypeFactory;
import io.ebeaninternal.server.type.ScalarType;
import io.ebeaninternal.server.type.ScalarTypeArraySet;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;

class ScalarTypeArraySetH2
extends ScalarTypeArraySet {
    static PlatformArrayTypeFactory factory() {
        return new Factory();
    }

    private ScalarTypeArraySetH2(boolean nullable, String arrayType, DocPropertyType docPropertyType, ArrayElementConverter converter) {
        super(nullable, arrayType, docPropertyType, converter);
    }

    @Override
    public void bind(DataBind bind, Set value) throws SQLException {
        if (value == null) {
            this.bindNull(bind);
        } else {
            bind.setObject(this.toArray(value));
        }
    }

    @Override
    protected void bindNull(DataBind bind) throws SQLException {
        if (this.nullable) {
            bind.setNull(2003);
        } else {
            bind.setObject(this.toArray(Collections.EMPTY_SET));
        }
    }

    static class Factory
    implements PlatformArrayTypeFactory {
        private final ReentrantLock lock = new ReentrantLock(false);
        private final Map<String, ScalarTypeArraySetH2> cache = new HashMap<String, ScalarTypeArraySetH2>();

        Factory() {
        }

        @Override
        public ScalarType<?> typeFor(Type valueType, boolean nullable) {
            this.lock.lock();
            try {
                String key = valueType + ":" + nullable;
                if (valueType.equals(UUID.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySetH2(nullable, "uuid", DocPropertyType.UUID, ArrayElementConverter.UUID));
                    return scalarType;
                }
                if (valueType.equals(Long.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySetH2(nullable, "bigint", DocPropertyType.LONG, ArrayElementConverter.LONG));
                    return scalarType;
                }
                if (valueType.equals(Integer.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySetH2(nullable, "integer", DocPropertyType.INTEGER, ArrayElementConverter.INTEGER));
                    return scalarType;
                }
                if (valueType.equals(Double.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySetH2(nullable, "float", DocPropertyType.DOUBLE, ArrayElementConverter.DOUBLE));
                    return scalarType;
                }
                if (valueType.equals(String.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySetH2(nullable, "varchar", DocPropertyType.TEXT, ArrayElementConverter.STRING));
                    return scalarType;
                }
                throw new IllegalArgumentException("Type [" + valueType + "] not supported for @DbArray mapping");
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public ScalarType<?> typeForEnum(ScalarType<?> scalarType, boolean nullable) {
            return new ScalarTypeArraySetH2(nullable, "varchar", DocPropertyType.TEXT, new ArrayElementConverter.EnumConverter(scalarType));
        }
    }
}

