/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.metric.TimedMetricStats;

class DTimeMetricStats
implements TimedMetricStats {
    private String name;
    private final boolean collected;
    private String location;
    private final long count;
    private final long total;
    private final long max;

    DTimeMetricStats(String name, boolean collected, long count, long total, long max) {
        this.name = name;
        this.collected = collected;
        this.count = count;
        this.total = total;
        this.max = max != Long.MIN_VALUE ? max : (long)(count < 1L ? 0 : Math.round(total / count));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append("name:").append(this.name).append(" ");
        }
        sb.append("count:").append(this.count).append(" total:").append(this.total).append(" max:").append(this.max);
        if (this.location != null) {
            sb.append(" loc:").append(this.location);
        }
        return sb.toString();
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean initialCollection() {
        return !this.collected;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public long getMax() {
        return this.max;
    }

    public long getMean() {
        return this.count < 1L ? 0L : Math.round((double)(this.total / this.count));
    }
}

