/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.Transaction;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiUpdatePlan;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dml.UpdateMeta;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.OptimisticLockException;

public class UpdateHandler
extends DmlHandler {
    private final UpdateMeta meta;
    private boolean emptySetClause;

    UpdateHandler(PersistRequestBean<?> persist, UpdateMeta meta) {
        super(persist);
        this.meta = meta;
    }

    @Override
    public boolean isUpdate() {
        return true;
    }

    @Override
    public void bind() throws SQLException {
        SpiUpdatePlan updatePlan = this.meta.getUpdatePlan(this.persistRequest);
        if (updatePlan.isEmptySetClause()) {
            this.emptySetClause = true;
            return;
        }
        this.sql = updatePlan.getSql();
        Transaction t = this.persistRequest.getTransaction();
        PreparedStatement pstmt = this.persistRequest.isBatched() ? this.getPstmtBatch((SpiTransaction)t, this.sql, this.persistRequest, false) : this.getPstmt((SpiTransaction)t, this.sql, false);
        this.dataBind = this.bind(pstmt);
        this.meta.bind(this.persistRequest, this, updatePlan);
        if (this.persistRequest.isBatched()) {
            this.batchedPstmt.registerInputStreams(this.dataBind.getInputStreams());
        }
        this.logSql(this.sql);
    }

    @Override
    public void addBatch() throws SQLException {
        if (!this.emptySetClause) {
            super.addBatch();
        }
    }

    @Override
    public int execute() throws SQLException, OptimisticLockException {
        if (!this.emptySetClause) {
            int rowCount = this.dataBind.executeUpdate();
            this.checkRowCount(rowCount);
            return rowCount;
        }
        return 0;
    }
}

