/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.annotation.Platform;
import io.ebean.bean.EntityBean;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableDiscriminator;
import io.ebeaninternal.server.persist.dmlbind.BindableId;
import io.ebeaninternal.server.persist.dmlbind.BindableList;
import java.sql.SQLException;

final class InsertMeta {
    private final String sqlNullId;
    private final String sqlWithId;
    private final String sqlDraftNullId;
    private final String sqlDraftWithId;
    private final BindableId id;
    private final Bindable discriminator;
    private final BindableList all;
    private final BindableList allExcludeDraftOnly;
    private final boolean supportsGetGeneratedKeys;
    private final boolean concatinatedKey;
    private final boolean supportsSelectLastInsertedId;
    private final Bindable shadowFKey;
    private final String[] identityDbColumns;
    private final Platform platform;

    InsertMeta(DatabasePlatform dbPlatform, BeanDescriptor<?> desc, Bindable shadowFKey, BindableId id, BindableList all) {
        this.platform = dbPlatform.getPlatform();
        this.discriminator = InsertMeta.getDiscriminator(desc);
        this.id = id;
        this.all = all;
        this.allExcludeDraftOnly = all.excludeDraftOnly();
        this.shadowFKey = shadowFKey;
        String tableName = desc.getBaseTable();
        String draftTableName = desc.getDraftTable();
        this.sqlWithId = this.genSql(false, tableName, false);
        String string = this.sqlDraftWithId = desc.isDraftable() ? this.genSql(false, draftTableName, true) : this.sqlWithId;
        if (id.isConcatenated()) {
            this.concatinatedKey = true;
            this.identityDbColumns = null;
            this.sqlNullId = null;
            this.sqlDraftNullId = null;
            this.supportsGetGeneratedKeys = false;
            this.supportsSelectLastInsertedId = false;
        } else {
            this.concatinatedKey = false;
            if (id.getIdentityColumn() == null) {
                this.identityDbColumns = new String[0];
                this.supportsGetGeneratedKeys = false;
                this.supportsSelectLastInsertedId = false;
            } else {
                this.identityDbColumns = new String[]{id.getIdentityColumn()};
                this.supportsGetGeneratedKeys = dbPlatform.getDbIdentity().isSupportsGetGeneratedKeys();
                this.supportsSelectLastInsertedId = desc.supportsSelectLastInsertedId();
            }
            this.sqlNullId = this.genSql(true, tableName, false);
            this.sqlDraftNullId = desc.isDraftable() ? this.genSql(true, draftTableName, true) : this.sqlNullId;
        }
    }

    private static Bindable getDiscriminator(BeanDescriptor<?> desc) {
        InheritInfo inheritInfo = desc.getInheritInfo();
        return inheritInfo != null ? new BindableDiscriminator(inheritInfo) : null;
    }

    boolean isConcatenatedKey() {
        return this.concatinatedKey;
    }

    String[] getIdentityDbColumns() {
        return this.identityDbColumns;
    }

    boolean supportsSelectLastInsertedId() {
        return this.supportsSelectLastInsertedId;
    }

    boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    boolean deriveConcatenatedId(PersistRequestBean<?> persist) {
        return this.id.deriveConcatenatedId(persist);
    }

    public void bind(DmlHandler request, EntityBean bean, boolean withId, boolean publish) throws SQLException {
        if (withId) {
            this.id.dmlBind(request, bean);
        }
        if (this.shadowFKey != null) {
            this.shadowFKey.dmlBind(request, bean);
        }
        if (this.discriminator != null) {
            this.discriminator.dmlBind(request, bean);
        }
        if (publish) {
            this.allExcludeDraftOnly.dmlBind(request, bean);
        } else {
            this.all.dmlBind(request, bean);
        }
    }

    public String getSql(boolean withId, boolean publish) {
        if (withId) {
            return publish ? this.sqlWithId : this.sqlDraftWithId;
        }
        return publish ? this.sqlNullId : this.sqlDraftNullId;
    }

    private String genSql(boolean nullId, String table, boolean draftTable) {
        GenerateDmlRequest request = new GenerateDmlRequest();
        request.setInsertSetMode();
        request.append("insert into ").append(table);
        if (nullId && this.noColumnsForInsert(draftTable)) {
            return request.append(this.defaultValues()).toString();
        }
        request.append(" (");
        if (!nullId) {
            this.id.dmlAppend(request);
        }
        if (this.shadowFKey != null) {
            this.shadowFKey.dmlAppend(request);
        }
        if (this.discriminator != null) {
            this.discriminator.dmlAppend(request);
        }
        if (draftTable) {
            this.all.dmlAppend(request);
        } else {
            this.allExcludeDraftOnly.dmlAppend(request);
        }
        request.append(") values (");
        request.append(request.getInsertBindBuffer());
        request.append(")");
        return request.toString();
    }

    private String defaultValues() {
        return this.platform.base() == Platform.MYSQL || this.platform.base() == Platform.MARIADB ? " values (default)" : " default values";
    }

    private boolean noColumnsForInsert(boolean draftTable) {
        return this.shadowFKey == null && this.discriminator == null && (draftTable ? this.all.isEmpty() : this.allExcludeDraftOnly.isEmpty());
    }
}

