/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.PersistenceContextScope;
import io.ebean.Transaction;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.ArrayList;
import java.util.List;

class DeleteUnloadedForeignKeys {
    private final List<BeanPropertyAssocOne<?>> propList = new ArrayList(4);
    private final SpiEbeanServer server;
    private final PersistRequestBean<?> request;
    private final boolean deletePermanent;
    private EntityBean beanWithForeignKeys;

    DeleteUnloadedForeignKeys(SpiEbeanServer server, PersistRequestBean<?> request) {
        this.server = server;
        this.request = request;
        this.deletePermanent = request.isHardDeleteCascade();
    }

    public void add(BeanPropertyAssocOne<?> prop) {
        this.propList.add(prop);
    }

    void queryForeignKeys() {
        BeanDescriptor<?> descriptor = this.request.getBeanDescriptor();
        SpiQuery q = (SpiQuery)this.server.createQuery(descriptor.getBeanType());
        Object id = this.request.getBeanId();
        StringBuilder sb = new StringBuilder(30);
        for (BeanPropertyAssocOne<?> aPropList : this.propList) {
            sb.append(aPropList.getName()).append(",");
        }
        q.setPersistenceContext(new DefaultPersistenceContext());
        q.setPersistenceContextScope(PersistenceContextScope.QUERY);
        q.setAutoTune(false);
        q.select(sb.toString());
        q.setIncludeSoftDeletes();
        q.where().idEq(id);
        Transaction t = this.request.getTransaction();
        if (t.isLogSummary()) {
            t.logSummary("-- Ebean fetching foreign key values for delete of " + descriptor.getName() + " id:" + id);
        }
        this.beanWithForeignKeys = (EntityBean)this.server.findOne(q, t);
    }

    void deleteCascade() {
        if (this.beanWithForeignKeys != null) {
            for (BeanPropertyAssocOne<?> prop : this.propList) {
                Object detailBean = prop.getValue(this.beanWithForeignKeys);
                if (detailBean == null || !prop.hasId((EntityBean)detailBean)) continue;
                if (this.deletePermanent) {
                    this.server.deletePermanent(detailBean, this.request.getTransaction());
                    continue;
                }
                this.server.delete(detailBean, this.request.getTransaction());
            }
        }
    }
}

