/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.server.persist.BatchPostExecute;
import io.ebeaninternal.server.persist.BatchedPstmt;
import io.ebeaninternal.server.persist.BatchedSqlException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedPstmtHolder {
    private static final Logger logger = LoggerFactory.getLogger(BatchedPstmtHolder.class);
    private final LinkedHashMap<String, BatchedPstmt> stmtMap = new LinkedHashMap();
    private int maxSize;

    BatchedPstmtHolder() {
    }

    PreparedStatement getStmt(String stmtKey, BatchPostExecute postExecute) throws SQLException {
        BatchedPstmt batchedPstmt = this.getBatchedPstmt(stmtKey);
        return batchedPstmt == null ? null : batchedPstmt.getStatement(postExecute);
    }

    public BatchedPstmt getBatchedPstmt(String stmtKey) {
        BatchedPstmt bs = this.stmtMap.get(stmtKey);
        if (bs == null) {
            return null;
        }
        int bsSize = bs.size();
        if (bsSize > this.maxSize) {
            this.maxSize = bsSize;
        }
        return bs;
    }

    public void addStmt(BatchedPstmt bs, BatchPostExecute postExecute) {
        bs.add(postExecute);
        this.stmtMap.put(bs.getSql(), bs);
    }

    public boolean isEmpty() {
        return this.stmtMap.isEmpty();
    }

    public int[] execute(String key, boolean getGeneratedKeys) throws SQLException {
        BatchedPstmt batchedPstmt = (BatchedPstmt)this.stmtMap.remove(key);
        if (batchedPstmt == null) {
            throw new PersistenceException("No batched statement found for key " + key);
        }
        batchedPstmt.executeBatch(getGeneratedKeys);
        return batchedPstmt.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean getGeneratedKeys) throws BatchedSqlException {
        SQLException firstError = null;
        String errorSql = null;
        boolean isError = false;
        BatchedPstmt[] values = this.stmtMap.values().toArray(new BatchedPstmt[0]);
        this.clear();
        for (BatchedPstmt bs : values) {
            try {
                if (isError) continue;
                bs.executeBatch(getGeneratedKeys);
            }
            catch (SQLException ex) {
                for (SQLException next = ex.getNextException(); next != null; next = next.getNextException()) {
                    logger.trace("Next Exception during batch execution", (Throwable)next);
                }
                firstError = ex;
                errorSql = bs.getSql();
                isError = true;
            }
            finally {
                try {
                    bs.close();
                }
                catch (SQLException ex) {
                    logger.error("Error closing batched PreparedStatement", (Throwable)ex);
                }
            }
        }
        if (firstError != null) {
            String msg = "Error when batch flush on sql: " + errorSql;
            throw new BatchedSqlException(msg, firstError);
        }
    }

    public void clear() {
        this.stmtMap.clear();
        this.maxSize = 0;
    }

    int getMaxSize() {
        return this.maxSize;
    }
}

