/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.persist.BatchPostExecute;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedPstmt
implements SpiProfileTransactionEvent {
    private static final Logger log = LoggerFactory.getLogger(BatchedPstmt.class);
    private PreparedStatement pstmt;
    private final boolean isGenKeys;
    private final ArrayList<BatchPostExecute> list = new ArrayList();
    private final String sql;
    private final SpiTransaction transaction;
    private long profileStart;
    private long timedStart;
    private int[] results;
    private List<InputStream> inputStreams;

    public BatchedPstmt(PreparedStatement pstmt, boolean isGenKeys, String sql, SpiTransaction transaction) throws SQLException {
        this.pstmt = pstmt;
        this.pstmt.clearBatch();
        this.isGenKeys = isGenKeys;
        this.sql = sql;
        this.transaction = transaction;
    }

    public int size() {
        return this.list.size();
    }

    public String getSql() {
        return this.sql;
    }

    public PreparedStatement getStatement(BatchPostExecute postExecute) throws SQLException {
        if (postExecute.isFlushQueue() && this.list.size() >= 20) {
            this.flushStatementBatch();
        }
        this.list.add(postExecute);
        return this.pstmt;
    }

    private void flushStatementBatch() throws SQLException {
        int[] rows = this.pstmt.executeBatch();
        if (rows.length != this.list.size()) {
            throw new IllegalStateException("Invalid state on executeBatch, rows:" + rows.length + " != " + this.list.size());
        }
        for (BatchPostExecute item : this.list) {
            item.postExecute();
        }
        this.list.clear();
    }

    public void add(BatchPostExecute batchExecute) {
        this.list.add(batchExecute);
    }

    public void executeBatch(boolean getGeneratedKeys) throws SQLException {
        this.timedStart = System.nanoTime();
        this.profileStart = this.transaction.profileOffset();
        this.executeAndCheckRowCounts();
        if (this.isGenKeys && getGeneratedKeys) {
            this.getGeneratedKeys();
        }
        this.postExecute();
        this.close();
        this.addTimingMetrics();
        this.transaction.profileEvent(this);
    }

    private void addTimingMetrics() {
        this.list.get(0).addTimingBatch(this.timedStart, this.list.size());
    }

    @Override
    public void profile() {
        this.list.get(0).profile(this.profileStart, this.list.size());
    }

    public void close() throws SQLException {
        if (this.pstmt != null) {
            this.pstmt.close();
            this.pstmt = null;
        }
    }

    private void postExecute() {
        for (BatchPostExecute item : this.list) {
            item.postExecute();
        }
    }

    private void executeAndCheckRowCounts() throws SQLException {
        try {
            this.results = this.pstmt.executeBatch();
            if (this.results.length != this.list.size()) {
                throw new SQLException("Invalid state on executeBatch, rows:" + this.results.length + " != " + this.list.size());
            }
            for (int i = 0; i < this.results.length; ++i) {
                this.list.get(i).checkRowCount(this.results[i]);
            }
        }
        finally {
            this.closeInputStreams();
        }
    }

    private void getGeneratedKeys() throws SQLException {
        int index = 0;
        try (ResultSet rset = this.pstmt.getGeneratedKeys();){
            while (rset.next()) {
                Object idValue = rset.getObject(1);
                this.list.get(index).setGeneratedKey(idValue);
                ++index;
            }
        }
    }

    public int[] getResults() {
        return this.results;
    }

    public void registerInputStreams(List<InputStream> inputStreams) {
        this.inputStreams = inputStreams;
    }

    private void closeInputStreams() {
        if (this.inputStreams != null) {
            for (InputStream inputStream : this.inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.warn("Error closing inputStream ", (Throwable)e);
                }
            }
        }
    }
}

