/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.lib;

import io.ebeaninternal.server.lib.DaemonThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaemonScheduleThreadPool
extends ScheduledThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DaemonScheduleThreadPool.class);
    private final ReentrantLock lock = new ReentrantLock(false);
    private final String namePrefix;
    private final int shutdownWaitSeconds;

    public DaemonScheduleThreadPool(int coreSize, int shutdownWaitSeconds, String namePrefix) {
        super(coreSize, new DaemonThreadFactory(namePrefix));
        this.namePrefix = namePrefix;
        this.shutdownWaitSeconds = shutdownWaitSeconds;
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            if (super.isShutdown()) {
                logger.debug("DaemonScheduleThreadPool {} already shut down", (Object)this.namePrefix);
                return;
            }
            try {
                logger.debug("DaemonScheduleThreadPool {} shutting down...", (Object)this.namePrefix);
                super.shutdown();
                if (!super.awaitTermination(this.shutdownWaitSeconds, TimeUnit.SECONDS)) {
                    logger.info("DaemonScheduleThreadPool shut down timeout exceeded. Terminating running threads.");
                    super.shutdownNow();
                }
            }
            catch (Exception e) {
                logger.error("Error during shutdown of " + this.namePrefix, (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

