/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.ScalarType;
import io.ebeaninternal.server.type.TypeManager;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.sql.SQLException;

class DtoMetaConstructor {
    private final Class<?>[] types;
    private final MethodHandle handle;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final ScalarType<?>[] scalarTypes;

    DtoMetaConstructor(TypeManager typeManager, Constructor<?> constructor, Class<?> someClass) throws NoSuchMethodException, IllegalAccessException {
        this.types = constructor.getParameterTypes();
        this.scalarTypes = new ScalarType[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            this.scalarTypes[i] = typeManager.getScalarType(this.types[i]);
        }
        this.handle = LOOKUP.findConstructor(someClass, this.typeFor(this.types));
    }

    private MethodType typeFor(Class<?>[] types) {
        return MethodType.methodType(Void.TYPE, types);
    }

    Class<?>[] getTypes() {
        return this.types;
    }

    int getArgCount() {
        return this.types.length;
    }

    Object defaultConstructor() {
        try {
            return this.handle.invokeWithArguments(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unexpected error invoking constructor", e);
        }
    }

    public Object process(DataReader dataReader) throws SQLException {
        Object[] values = new Object[this.scalarTypes.length];
        for (int i = 0; i < this.scalarTypes.length; ++i) {
            values[i] = this.scalarTypes[i].read(dataReader);
        }
        return this.invoke(values);
    }

    private Object invoke(Object ... args) {
        try {
            return this.handle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unexpected error invoking constructor", e);
        }
    }
}

