/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.TenantCatalogProvider;
import io.ebean.datasource.DataSourcePool;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class MultiTenantDbCatalogSupplier
implements DataSourceSupplier {
    private final DataSource dataSource;
    private final DataSource readOnlyDataSource;
    private final CatalogDataSource catalogDataSource;
    private final CatalogDataSource readOnly;

    MultiTenantDbCatalogSupplier(CurrentTenantProvider tenantProvider, DataSource dataSource, DataSource readOnlyDataSource, TenantCatalogProvider catalogProvider) {
        this.dataSource = dataSource;
        this.readOnlyDataSource = readOnlyDataSource;
        this.catalogDataSource = new CatalogDataSource(dataSource, tenantProvider, catalogProvider);
        this.readOnly = readOnlyDataSource == null ? null : new CatalogDataSource(readOnlyDataSource, tenantProvider, catalogProvider);
    }

    @Override
    public DataSource getDataSource() {
        return this.catalogDataSource;
    }

    @Override
    public DataSource getReadOnlyDataSource() {
        return this.readOnly;
    }

    @Override
    public Connection getConnection(Object tenantId) throws SQLException {
        return this.catalogDataSource.getConnectionForTenant(tenantId);
    }

    @Override
    public Connection getReadOnlyConnection(Object tenantId) throws SQLException {
        return this.readOnly.getConnectionForTenant(tenantId);
    }

    @Override
    public void shutdown(boolean deregisterDriver) {
        if (this.readOnlyDataSource instanceof DataSourcePool) {
            ((DataSourcePool)this.readOnlyDataSource).shutdown();
        }
        if (this.dataSource instanceof DataSourcePool) {
            ((DataSourcePool)this.dataSource).shutdown();
        }
    }

    private static class CatalogDataSource
    implements DataSource {
        final DataSource dataSource;
        final CurrentTenantProvider tenantProvider;
        final TenantCatalogProvider catalogProvider;

        CatalogDataSource(DataSource dataSource, CurrentTenantProvider tenantProvider, TenantCatalogProvider catalogProvider) {
            this.dataSource = dataSource;
            this.tenantProvider = tenantProvider;
            this.catalogProvider = catalogProvider;
        }

        private String tenantCatalog() {
            return this.catalogProvider.catalog(this.tenantProvider.currentId());
        }

        Connection getConnectionForTenant(Object tenantId) throws SQLException {
            Connection connection = this.dataSource.getConnection();
            connection.setCatalog(this.catalogProvider.catalog(tenantId));
            return connection;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = this.dataSource.getConnection();
            connection.setCatalog(this.tenantCatalog());
            return connection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.dataSource.getConnection(username, password);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.dataSource.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.dataSource.isWrapperFor(iface);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.dataSource.getParentLogger();
        }
    }
}

