/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.Database;
import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaMetric;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricData;
import io.ebean.meta.ServerMetrics;
import java.util.ArrayList;
import java.util.List;

class DumpMetricsData {
    private final Database database;
    private final List<MetricData> list = new ArrayList<MetricData>();

    DumpMetricsData(Database database) {
        this.database = database;
    }

    List<MetricData> data() {
        this.collect(this.database.getMetaInfoManager().collectMetrics());
        return this.list;
    }

    private void collect(ServerMetrics serverMetrics) {
        List timedMetrics = serverMetrics.getTimedMetrics();
        List countMetrics = serverMetrics.getCountMetrics();
        List queryMetrics = serverMetrics.getQueryMetrics();
        for (MetaTimedMetric metric : timedMetrics) {
            this.add(metric);
        }
        for (MetaTimedMetric metric : countMetrics) {
            this.addCount((MetaCountMetric)metric);
        }
        for (MetaTimedMetric metric : queryMetrics) {
            this.addQuery((MetaQueryMetric)metric);
        }
    }

    private MetricData create(MetaMetric metric) {
        MetricData data = new MetricData(metric.getName());
        this.list.add(data);
        return data;
    }

    private void add(MetaTimedMetric metric) {
        MetricData data = this.create((MetaMetric)metric);
        this.appendCounters(data, metric);
        data.setLoc(metric.getLocation());
    }

    private void addCount(MetaCountMetric metric) {
        MetricData data = this.create((MetaMetric)metric);
        data.setCount(Long.valueOf(metric.getCount()));
    }

    private void addQuery(MetaQueryMetric metric) {
        MetricData data = this.create((MetaMetric)metric);
        this.appendCounters(data, (MetaTimedMetric)metric);
        this.appendLocationAndSql(data, metric);
        data.setHash(metric.getHash());
    }

    private void appendLocationAndSql(MetricData data, MetaQueryMetric metric) {
        data.setLoc(metric.getLocation());
        data.setSql(metric.getSql());
    }

    private void appendCounters(MetricData data, MetaTimedMetric timedMetric) {
        data.setCount(Long.valueOf(timedMetric.getCount()));
        data.setTotal(Long.valueOf(timedMetric.getTotal()));
        data.setMean(Long.valueOf(timedMetric.getMean()));
        data.setMax(Long.valueOf(timedMetric.getMax()));
    }
}

