/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.annotation.Cache;

public class CacheOptions {
    public static final CacheOptions NO_CACHING = new CacheOptions();
    private static final String R0 = "r0";
    private static final CacheOptions INVALIDATE_QUERY_CACHE_R0 = new CacheOptions(true);
    private final boolean invalidateQueryCache;
    private final boolean enableBeanCache;
    private final boolean enableQueryCache;
    private final boolean readOnly;
    private final String[] naturalKey;
    private final String region;

    public static CacheOptions invalidateQueryCache(String region) {
        if (R0.equals(region)) {
            return INVALIDATE_QUERY_CACHE_R0;
        }
        return new CacheOptions(true, region);
    }

    private CacheOptions() {
        this.invalidateQueryCache = false;
        this.enableBeanCache = false;
        this.enableQueryCache = false;
        this.readOnly = false;
        this.naturalKey = null;
        this.region = null;
    }

    private CacheOptions(boolean invalidateQueryCache) {
        this(invalidateQueryCache, R0);
    }

    private CacheOptions(boolean invalidateQueryCache, String region) {
        this.invalidateQueryCache = invalidateQueryCache;
        this.enableBeanCache = false;
        this.enableQueryCache = false;
        this.readOnly = false;
        this.naturalKey = null;
        this.region = region;
    }

    public CacheOptions(Cache cache, String[] naturalKey) {
        this.invalidateQueryCache = false;
        this.enableBeanCache = cache.enableBeanCache();
        this.enableQueryCache = cache.enableQueryCache();
        this.readOnly = cache.readOnly();
        this.naturalKey = naturalKey;
        this.region = cache.region();
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isInvalidateQueryCache() {
        return this.invalidateQueryCache;
    }

    public boolean isEnableBeanCache() {
        return this.enableBeanCache;
    }

    public boolean isEnableQueryCache() {
        return this.enableQueryCache;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String[] getNaturalKey() {
        return this.naturalKey;
    }
}

