/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import java.util.LinkedHashMap;

public class CachedBeanDataFromBean {
    public static CachedBeanData extract(BeanDescriptor<?> desc, EntityBean bean) {
        int propertyIndex;
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        BeanProperty idProperty = desc.getIdProperty();
        if (idProperty != null && ebi.isLoadedProperty(propertyIndex = idProperty.getPropertyIndex())) {
            data.put(idProperty.getName(), idProperty.getCacheDataValue(bean));
        }
        boolean dirty = ebi.isDirty();
        for (BeanProperty beanProperty : desc.propertiesNonMany()) {
            if (dirty && ebi.isDirtyProperty(beanProperty.getPropertyIndex())) {
                data.put(beanProperty.getName(), beanProperty.getCacheDataValueOrig(ebi));
                continue;
            }
            if (!ebi.isLoadedProperty(beanProperty.getPropertyIndex())) continue;
            data.put(beanProperty.getName(), beanProperty.getCacheDataValue(bean));
        }
        for (BeanProperty beanProperty : desc.propertiesMany()) {
            if (!((BeanPropertyAssocMany)beanProperty).isElementCollection()) continue;
            data.put(beanProperty.getName(), ((BeanPropertyAssocMany)beanProperty).getCacheDataValue(bean));
        }
        long version = desc.getVersion(bean);
        EntityBean sharableBean = CachedBeanDataFromBean.createSharableBean(desc, bean, ebi);
        return new CachedBeanData(sharableBean, desc.getDiscValue(), data, version);
    }

    private static EntityBean createSharableBean(BeanDescriptor<?> desc, EntityBean bean, EntityBeanIntercept beanEbi) {
        BeanProperty[] propertiesNonTransient;
        if (!desc.isCacheSharableBeans() || !beanEbi.isFullyLoadedBean()) {
            return null;
        }
        if (beanEbi.isReadOnly()) {
            return bean;
        }
        EntityBean sharableBean = desc.createEntityBean();
        BeanProperty idProp = desc.getIdProperty();
        if (idProp != null) {
            Object v = idProp.getValue(bean);
            idProp.setValue(sharableBean, v);
        }
        for (BeanProperty aPropertiesNonTransient : propertiesNonTransient = desc.propertiesNonTransient()) {
            Object v = aPropertiesNonTransient.getValue(bean);
            aPropertiesNonTransient.setValue(sharableBean, v);
        }
        EntityBeanIntercept intercept = sharableBean._ebean_getIntercept();
        intercept.setReadOnly(true);
        intercept.setLoaded();
        return sharableBean;
    }
}

