/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.config.ClassLoadConfig;
import java.util.Properties;

public class PropertiesWrapper {
    protected final Properties properties;
    protected final String prefix;
    protected final String serverName;
    private final ClassLoadConfig classLoadConfig;

    public PropertiesWrapper(String prefix, String serverName, Properties properties, ClassLoadConfig classLoadConfig) {
        this.serverName = serverName;
        this.prefix = prefix;
        this.properties = properties;
        this.classLoadConfig = classLoadConfig;
    }

    public PropertiesWrapper(Properties properties, ClassLoadConfig classLoadConfig) {
        this(null, null, properties, classLoadConfig);
    }

    public String getServerName() {
        return this.serverName;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String value = null;
        if (this.serverName != null && this.prefix != null) {
            value = this.internalGet(this.prefix + "." + this.serverName + "." + key);
        }
        if (value == null && this.prefix != null) {
            value = this.internalGet(this.prefix + "." + key);
        }
        if (value == null) {
            value = this.internalGet(key);
        }
        return value == null ? defaultValue : value;
    }

    private String internalGet(String key) {
        return this.properties.getProperty(key);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Double.parseDouble(value);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Integer.parseInt(value);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Long.parseLong(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumType, String key, T defaultValue) {
        String level = this.get(key, null);
        return level == null ? defaultValue : Enum.valueOf(enumType, level.toUpperCase());
    }

    public <T> T createInstance(Class<T> pluginType, String key, T instance) {
        if (instance != null) {
            return instance;
        }
        String classname = this.get(key, null);
        return this.createInstance(pluginType, classname);
    }

    public <T> T createInstance(Class<T> pluginType, String classname) {
        return (T)(classname == null ? null : this.classLoadConfig.newInstance(classname));
    }
}

