/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

public class DbConstraintNormalise {
    protected final String[] quotedIdentifiers;
    protected final boolean lowerCaseTables;
    protected final boolean lowerCaseColumns;

    public DbConstraintNormalise() {
        this(true, true);
    }

    public DbConstraintNormalise(boolean lowerCaseTables, boolean lowerCaseColumns) {
        this.lowerCaseTables = lowerCaseTables;
        this.lowerCaseColumns = lowerCaseColumns;
        this.quotedIdentifiers = new String[]{"\"", "'", "[", "]", "`"};
    }

    public String normaliseTable(String tableName) {
        int lastPeriod = (tableName = this.trimQuotes(tableName)).lastIndexOf(46);
        if (lastPeriod > -1) {
            tableName = tableName.substring(lastPeriod + 1);
        }
        if (this.lowerCaseTables) {
            tableName = tableName.toLowerCase();
        }
        return tableName;
    }

    public String normaliseColumn(String columnName) {
        columnName = this.trimBrackets(this.trimQuotes(columnName));
        if (this.lowerCaseColumns) {
            columnName = columnName.toLowerCase();
        }
        return columnName;
    }

    private String trimBrackets(String value) {
        return value.replace("(", "").replace(")", "");
    }

    public String trimQuotes(String identifier) {
        if (identifier == null) {
            return "";
        }
        for (String quotedIdentifier : this.quotedIdentifiers) {
            identifier = identifier.replace(quotedIdentifier, "");
        }
        return identifier;
    }
}

