/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.avaje.lang.NonNullApi;
import io.avaje.lang.Nullable;
import io.ebean.DB;
import io.ebean.Database;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import java.util.List;
import java.util.Optional;

@NonNullApi
public abstract class BeanFinder<I, T> {
    protected final Database database;
    protected final Class<T> type;

    protected BeanFinder(Class<T> type, Database database) {
        this.type = type;
        this.database = database;
    }

    public Database db() {
        return this.database;
    }

    public Transaction currentTransaction() {
        return this.db().currentTransaction();
    }

    public void flush() {
        this.db().flush();
    }

    public Database db(String name) {
        return DB.byName(name);
    }

    public T ref(I id) {
        return this.db().reference(this.type, id);
    }

    @Nullable
    public T findById(I id) {
        return this.db().find(this.type, id);
    }

    public Optional<T> findByIdOrEmpty(I id) {
        return this.db().find(this.type).setId(id).findOneOrEmpty();
    }

    public void deleteById(I id) {
        this.db().delete(this.type, id);
    }

    public List<T> findAll() {
        return this.query().findList();
    }

    protected UpdateQuery<T> updateQuery() {
        return this.db().update(this.type);
    }

    protected Query<T> query() {
        return this.db().find(this.type);
    }

    protected Query<T> nativeSql(String nativeSql) {
        return this.db().findNative(this.type, nativeSql);
    }

    protected Query<T> query(String ormQuery) {
        return this.db().createQuery(this.type, ormQuery);
    }
}

