/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.avaje.applog.AppLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Properties;

public final class EbeanVersion {
    public static final System.Logger log = AppLog.getLogger((String)"io.ebean");
    private static final int MIN_AGENT_MAJOR_VERSION = 12;
    private static final int MIN_AGENT_MINOR_VERSION = 12;
    private static String version = "unknown";

    private static void readVersion() {
        block13: {
            try (InputStream in = ClassLoader.getSystemResourceAsStream("META-INF/ebean-maven-version.txt");){
                if (in == null) break block13;
                try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));){
                    version = reader.readLine();
                    log.log(System.Logger.Level.INFO, "ebean version: {0}", version);
                }
            }
            catch (IOException e) {
                log.log(System.Logger.Level.WARNING, "Could not determine ebean version: {0}", e.getMessage());
            }
        }
    }

    private static void checkAgentVersion() {
        try (InputStream in = ClassLoader.getSystemResourceAsStream("META-INF/maven/io.ebean/ebean-agent/pom.properties");){
            String agentVersion;
            if (in != null && (agentVersion = EbeanVersion.readVersion(in)) != null && EbeanVersion.checkMinAgentVersion(agentVersion)) {
                log.log(System.Logger.Level.ERROR, "Expected minimum ebean-agent version {0}.{1}.0 but we have {2}, please update the ebean-agent", 12, 12, agentVersion);
            }
        }
        catch (IOException e) {
            log.log(System.Logger.Level.WARNING, "Could not check minimum ebean-agent version {0}.{1}.0 required due to - {2}", 12, 12, e.getMessage());
        }
    }

    static boolean checkMinAgentVersion(String agentVersion) {
        String[] versionSegments = agentVersion.split("\\.");
        if (versionSegments.length != 3) {
            return true;
        }
        int major = Integer.parseInt(versionSegments[0]);
        int minor = Integer.parseInt(versionSegments[1]);
        if (major < 12) {
            return true;
        }
        return major == 12 && minor < 12;
    }

    private static String readVersion(InputStream in) throws IOException {
        Properties prop = new Properties();
        prop.load(in);
        in.close();
        return prop.getProperty("version");
    }

    private EbeanVersion() {
    }

    public static String getVersion() {
        return version;
    }

    static {
        EbeanVersion.readVersion();
        EbeanVersion.checkAgentVersion();
    }
}

