/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform.mysql;

import io.ebean.Query;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.SqlErrorCodes;
import io.ebean.config.dbplatform.mysql.MySqlBlob;
import io.ebean.config.dbplatform.mysql.MySqlClob;
import io.ebean.config.dbplatform.mysql.MySqlDbEncrypt;
import io.ebean.config.dbplatform.mysql.MySqlHistorySupport;

public abstract class BaseMySqlPlatform
extends DatabasePlatform {
    public BaseMySqlPlatform() {
        this.useExtraTransactionOnIterateSecondaryQueries = true;
        this.selectCountWithAlias = true;
        this.supportsSavepointId = false;
        this.inlineSqlUpdateLimit = true;
        this.dbEncrypt = new MySqlDbEncrypt();
        this.historySupport = new MySqlHistorySupport();
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsIdentity(true);
        this.dbIdentity.setSupportsSequence(false);
        this.dbDefaultValue.setNow("now(6)");
        this.dbDefaultValue.setFalse("0");
        this.dbDefaultValue.setTrue("1");
        this.exceptionTranslator = new SqlErrorCodes().addAcquireLock("1205").addDuplicateKey("1062", "1169").addDataIntegrity("630", "839", "840", "893", "1215", "1216", "1217", "1364", "1451", "1452", "1557").build();
        this.openQuote = "`";
        this.closeQuote = "`";
        this.likeClauseRaw = "like ? escape''";
        this.likeClauseEscaped = "like ? escape'|'";
        this.forwardOnlyHintOnFindIterate = true;
        this.booleanDbType = -7;
        this.dbTypeMap.put(DbType.BIT, new DbPlatformType("tinyint(1)"));
        this.dbTypeMap.put(DbType.BOOLEAN, new DbPlatformType("tinyint(1)"));
        this.dbTypeMap.put(DbType.TIMESTAMP, new DbPlatformType("datetime(6)"));
        this.dbTypeMap.put(DbType.CLOB, new MySqlClob());
        this.dbTypeMap.put(DbType.BLOB, new MySqlBlob());
        this.dbTypeMap.put(DbType.BINARY, new DbPlatformType("binary", 255));
        this.dbTypeMap.put(DbType.VARBINARY, new DbPlatformType("varbinary", 255));
        this.dbTypeMap.put(DbType.JSON, new DbPlatformType("json", false));
        this.dbTypeMap.put(DbType.JSONB, new DbPlatformType("json", false));
    }

    @Override
    protected String withForUpdate(String sql, Query.ForUpdate forUpdateMode) {
        return sql + " for update";
    }
}

