/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform.h2;

import io.ebean.BackgroundExecutor;
import io.ebean.Query;
import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.config.dbplatform.SqlErrorCodes;
import io.ebean.config.dbplatform.h2.H2DbEncrypt;
import io.ebean.config.dbplatform.h2.H2HistorySupport;
import io.ebean.config.dbplatform.h2.H2SequenceIdGenerator;
import javax.sql.DataSource;

public class H2Platform
extends DatabasePlatform {
    public H2Platform() {
        this.platform = Platform.H2;
        this.dbEncrypt = new H2DbEncrypt();
        this.historySupport = new H2HistorySupport();
        this.nativeUuidType = true;
        this.supportsDeleteTableAlias = true;
        this.inlineSqlUpdateLimit = true;
        this.dbDefaultValue.setNow("now()");
        this.exceptionTranslator = new SqlErrorCodes().addAcquireLock("50200", "HYT00").addDuplicateKey("23001", "23505").addDataIntegrity("22001", "22003", "22012", "22018", "22025", "23000", "23002", "23003", "23502", "23503", "23506", "23507", "23513").build();
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsSequence(true);
        this.dbIdentity.setSupportsIdentity(true);
        this.dbTypeMap.put(DbType.UUID, new DbPlatformType("uuid", false));
    }

    @Override
    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, int stepSize, String seqName) {
        return new H2SequenceIdGenerator(be, ds, seqName, this.sequenceBatchSize);
    }

    @Override
    protected String withForUpdate(String sql, Query.ForUpdate forUpdateMode) {
        return sql + " for update";
    }
}

