/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.BackgroundExecutor;
import io.ebean.Transaction;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.util.JdbcClose;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SequenceIdGenerator
implements PlatformIdGenerator {
    protected static final Logger logger = LoggerFactory.getLogger((String)"io.ebean.SEQ");
    private final ReentrantLock lock = new ReentrantLock(false);
    private final ReentrantLock loadLock = new ReentrantLock(false);
    protected final String seqName;
    protected final DataSource dataSource;
    protected final BackgroundExecutor backgroundExecutor;
    protected final NavigableSet<Long> idList = new TreeSet<Long>();
    protected final int allocationSize;
    protected boolean currentlyBackgroundLoading;

    protected SequenceIdGenerator(BackgroundExecutor be, DataSource ds, String seqName, int allocationSize) {
        this.backgroundExecutor = be;
        this.dataSource = ds;
        this.seqName = seqName;
        this.allocationSize = allocationSize;
    }

    public abstract String getSql(int var1);

    @Override
    public String getName() {
        return this.seqName;
    }

    @Override
    public boolean isDbSequence() {
        return true;
    }

    @Override
    public void preAllocateIds(int requestSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nextId(Transaction t) {
        this.lock.lock();
        try {
            int size = this.idList.size();
            if (size > 0) {
                this.maybeLoadMoreInBackground(size);
            } else {
                this.loadMore(this.allocationSize);
            }
            Long l = this.idList.pollFirst();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void maybeLoadMoreInBackground(int currentSize) {
        if (this.allocationSize > 1 && currentSize <= this.allocationSize / 2) {
            this.loadInBackground(this.allocationSize);
        }
    }

    private void loadMore(int requestSize) {
        List<Long> newIds = this.getMoreIds(requestSize);
        this.lock.lock();
        try {
            this.idList.addAll(newIds);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void loadInBackground(int requestSize) {
        this.loadLock.lock();
        try {
            if (this.currentlyBackgroundLoading) {
                logger.debug("... skip background sequence load (another load in progress)");
                return;
            }
            this.currentlyBackgroundLoading = true;
            this.backgroundExecutor.execute(() -> {
                this.loadMore(requestSize);
                this.loadLock.lock();
                try {
                    this.currentlyBackgroundLoading = false;
                }
                finally {
                    this.loadLock.unlock();
                }
            });
        }
        finally {
            this.loadLock.lock();
        }
    }

    protected abstract List<Long> readIds(ResultSet var1, int var2) throws SQLException;

    protected List<Long> getMoreIds(int requestSize) {
        String sql = this.getSql(requestSize);
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(sql);
            resultSet = statement.executeQuery();
            List<Long> newIds = this.readIds(resultSet, requestSize);
            if (logger.isTraceEnabled()) {
                logger.trace("seq:{} loaded:{} sql:{}", new Object[]{this.seqName, newIds.size(), sql});
            }
            if (newIds.isEmpty()) {
                throw new PersistenceException("Always expecting more than 1 row from " + sql);
            }
            List<Long> list = newIds;
            this.closeResources(connection, statement, resultSet);
            return list;
        }
        catch (SQLException e) {
            block7: {
                try {
                    if (!e.getMessage().contains("Database is already closed")) break block7;
                    String msg = "Error getting SEQ when DB shutting down " + e.getMessage();
                    logger.error(msg);
                    System.out.println(msg);
                    List<Long> list = Collections.emptyList();
                    this.closeResources(connection, statement, resultSet);
                    return list;
                }
                catch (Throwable throwable) {
                    this.closeResources(connection, statement, resultSet);
                    throw throwable;
                }
            }
            throw new PersistenceException("Error getting sequence nextval", (Throwable)e);
        }
    }

    private void closeResources(Connection connection, PreparedStatement statement, ResultSet resultSet) {
        JdbcClose.close(resultSet);
        JdbcClose.close(statement);
        JdbcClose.close(connection);
    }
}

