/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.EbeanVersion;
import io.ebean.annotation.Platform;
import io.ebean.config.PropertiesWrapper;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationRunner;
import io.ebean.util.StringHelper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigrationConfig {
    protected static final Logger logger = LoggerFactory.getLogger(DbMigrationConfig.class);
    protected MigrationConfig runnerConfig = new MigrationConfig();
    protected Platform platform;
    protected String migrationPath = "dbmigration";
    protected String migrationInitPath = "dbinit";
    protected String modelPath = "model";
    protected String applySuffix = ".sql";
    protected String applyPrefix = "";
    protected String modelSuffix = ".model.xml";
    protected String metaTable = "db_migration";
    protected boolean runMigration;
    protected String runPlaceholders;
    protected Map<String, String> runPlaceholderMap;
    protected String dbSchema;
    protected boolean defaultDbSchema;
    protected String dbUsername;
    protected String dbPassword;
    protected String patchInsertOn;
    protected String patchResetChecksumOn;
    protected boolean strictMode = true;
    protected String ddlHeader;

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public String getMigrationPath(boolean dbinitMigration) {
        return dbinitMigration ? this.migrationInitPath : this.migrationPath;
    }

    public String getMigrationPath() {
        return this.migrationPath;
    }

    public void setMigrationPath(String migrationPath) {
        this.migrationPath = migrationPath;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public String getModelSuffix() {
        return this.modelSuffix;
    }

    public void setModelSuffix(String modelSuffix) {
        this.modelSuffix = modelSuffix;
    }

    public String getApplySuffix() {
        return this.applySuffix;
    }

    public void setApplySuffix(String applySuffix) {
        this.applySuffix = applySuffix;
    }

    public String getApplyPrefix() {
        return this.applyPrefix;
    }

    public void setApplyPrefix(String applyPrefix) {
        this.applyPrefix = applyPrefix;
    }

    public String getMetaTable() {
        return this.metaTable;
    }

    public void setMetaTable(String metaTable) {
        this.metaTable = metaTable;
    }

    public String getRunPlaceholders() {
        String placeholders = this.readEnvironment("ddl.migration.placeholders");
        if (placeholders != null) {
            return placeholders;
        }
        return this.runPlaceholders;
    }

    public void setRunPlaceholders(String runPlaceholders) {
        this.runPlaceholders = runPlaceholders;
    }

    public Map<String, String> getRunPlaceholderMap() {
        return this.runPlaceholderMap;
    }

    public void setRunPlaceholderMap(Map<String, String> runPlaceholderMap) {
        this.runPlaceholderMap = runPlaceholderMap;
    }

    public boolean isRunMigration() {
        String run = this.readEnvironment("ddl.migration.run");
        if (run != null) {
            return "true".equalsIgnoreCase(run.trim());
        }
        return this.runMigration;
    }

    public void setRunMigration(boolean runMigration) {
        this.runMigration = runMigration;
    }

    public String getDbUsername() {
        String user = this.readEnvironment("ddl.migration.user");
        if (user != null) {
            return user;
        }
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        String user = this.readEnvironment("ddl.migration.password");
        if (user != null) {
            return user;
        }
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getDbSchema() {
        String schema = this.readEnvironment("ddl.migration.schema");
        if (schema != null) {
            return schema;
        }
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setDefaultDbSchema(String dbSchema) {
        this.defaultDbSchema = true;
        this.dbSchema = dbSchema;
    }

    public boolean isDefaultDbSchema() {
        return this.defaultDbSchema;
    }

    public String getPatchInsertOn() {
        return this.patchInsertOn;
    }

    public void setPatchInsertOn(String patchInsertOn) {
        this.patchInsertOn = patchInsertOn;
    }

    public String getPatchResetChecksumOn() {
        return this.patchResetChecksumOn;
    }

    public String getDdlHeader() {
        if (this.ddlHeader != null && !this.ddlHeader.isEmpty()) {
            this.ddlHeader = StringHelper.replace(this.ddlHeader, "${version}", EbeanVersion.getVersion());
            this.ddlHeader = StringHelper.replace(this.ddlHeader, "${timestamp}", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
        }
        return this.ddlHeader;
    }

    public void setDdlHeader(String ddlHeader) {
        this.ddlHeader = ddlHeader;
    }

    public void setPatchResetChecksumOn(String patchResetChecksumOn) {
        this.patchResetChecksumOn = patchResetChecksumOn;
    }

    public boolean isStrictMode() {
        String envValue = this.readEnvironment("ddl.migration.strictMode");
        if (!this.isEmpty(envValue)) {
            return Boolean.parseBoolean(envValue.trim());
        }
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public MigrationConfig getRunnerConfig() {
        return this.runnerConfig;
    }

    public void loadSettings(PropertiesWrapper properties, String serverName) {
        this.migrationPath = properties.get("migration.migrationPath", this.migrationPath);
        this.migrationInitPath = properties.get("migration.migrationInitPath", this.migrationInitPath);
        this.modelPath = properties.get("migration.modelPath", this.modelPath);
        this.applyPrefix = properties.get("migration.applyPrefix", this.applyPrefix);
        this.applySuffix = properties.get("migration.applySuffix", this.applySuffix);
        this.modelSuffix = properties.get("migration.modelSuffix", this.modelSuffix);
        this.platform = properties.getEnum(Platform.class, "migration.platform", this.platform);
        this.patchInsertOn = properties.get("migration.patchInsertOn", this.patchInsertOn);
        this.patchResetChecksumOn = properties.get("migration.patchResetChecksumOn", this.patchResetChecksumOn);
        this.runMigration = properties.getBoolean("migration.run", this.runMigration);
        this.metaTable = properties.get("migration.metaTable", this.metaTable);
        this.runPlaceholders = properties.get("migration.placeholders", this.runPlaceholders);
        this.dbSchema = properties.get("migration.dbSchema", this.dbSchema);
        String adminUser = properties.get("datasource." + serverName + ".adminusername", this.dbUsername);
        this.dbUsername = properties.get("migration.dbusername", adminUser);
        String adminPwd = properties.get("datasource." + serverName + ".adminpassword", this.dbPassword);
        this.dbPassword = properties.get("migration.dbpassword", adminPwd);
        this.ddlHeader = properties.get("ddl.header", this.ddlHeader);
    }

    protected String readEnvironment(String key) {
        String val = System.getProperty(key);
        if (val == null) {
            val = System.getenv(key);
        }
        return val;
    }

    protected boolean isEmpty(String val) {
        return val == null || val.trim().isEmpty();
    }

    public MigrationRunner createRunner(ClassLoader classLoader, Properties properties) {
        this.runnerConfig.setMetaTable(this.metaTable);
        this.runnerConfig.setApplySuffix(this.applySuffix);
        this.runnerConfig.setMigrationPath(this.migrationPath);
        this.runnerConfig.setMigrationInitPath(this.migrationInitPath);
        this.runnerConfig.setRunPlaceholderMap(this.runPlaceholderMap);
        this.runnerConfig.setRunPlaceholders(this.runPlaceholders);
        this.runnerConfig.setDbUsername(this.getDbUsername());
        this.runnerConfig.setDbPassword(this.getDbPassword());
        this.runnerConfig.setDbSchema(this.getDbSchema());
        if (this.defaultDbSchema) {
            this.runnerConfig.setSetCurrentSchema(false);
        }
        this.runnerConfig.setClassLoader(classLoader);
        if (this.patchInsertOn != null) {
            this.runnerConfig.setPatchInsertOn(this.patchInsertOn);
        }
        if (this.patchResetChecksumOn != null) {
            this.runnerConfig.setPatchResetChecksumOn(this.patchResetChecksumOn);
        }
        if (properties != null) {
            this.runnerConfig.load(properties);
        }
        return new MigrationRunner(this.runnerConfig);
    }
}

